// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeField
import aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary
import aws.sdk.kotlin.services.customerprofiles.model.StatusReason
import aws.sdk.kotlin.services.customerprofiles.model.UploadJobStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetUploadJobOperationDeserializer: HttpDeserializer.NonStreaming<GetUploadJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUploadJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUploadJobError(context, call, payload)
        }
        val builder = GetUploadJobResponse.Builder()

        if (payload != null) {
            deserializeGetUploadJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUploadJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUploadJobOperationBody(builder: GetUploadJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPLETEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedAt"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DATAEXPIRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DataExpiry"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Fields"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val RESULTSSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResultsSummary"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StatusReason"))
    val UNIQUEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UniqueKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLETEDAT_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATAEXPIRY_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(RESULTSSUMMARY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
        field(UNIQUEKEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPLETEDAT_DESCRIPTOR.index -> builder.completedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DATAEXPIRY_DESCRIPTOR.index -> builder.dataExpiry = deserializeInt()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                FIELDS_DESCRIPTOR.index -> builder.fields =
                    deserializer.deserializeMap(FIELDS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ObjectTypeField>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeObjectTypeFieldDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                RESULTSSUMMARY_DESCRIPTOR.index -> builder.resultsSummary = deserializeResultsSummaryDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { UploadJobStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString().let { StatusReason.fromValue(it) }
                UNIQUEKEY_DESCRIPTOR.index -> builder.uniqueKey = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
