// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.AttributeDetails
import aws.sdk.kotlin.services.customerprofiles.model.Conditions
import aws.sdk.kotlin.services.customerprofiles.model.CreateCalculatedAttributeDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.Filter
import aws.sdk.kotlin.services.customerprofiles.model.Readiness
import aws.sdk.kotlin.services.customerprofiles.model.ReadinessStatus
import aws.sdk.kotlin.services.customerprofiles.model.Statistic
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class CreateCalculatedAttributeDefinitionOperationDeserializer: HttpDeserializer.NonStreaming<CreateCalculatedAttributeDefinitionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCalculatedAttributeDefinitionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCalculatedAttributeDefinitionError(context, call, payload)
        }
        val builder = CreateCalculatedAttributeDefinitionResponse.Builder()

        if (payload != null) {
            deserializeCreateCalculatedAttributeDefinitionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCalculatedAttributeDefinitionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCalculatedAttributeDefinitionOperationBody(builder: CreateCalculatedAttributeDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeDetails"))
    val CALCULATEDATTRIBUTENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CalculatedAttributeName"))
    val CONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Conditions"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val FILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filter"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val READINESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Readiness"))
    val STATISTIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Statistic"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val USEHISTORICALDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseHistoricalData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEDETAILS_DESCRIPTOR)
        field(CALCULATEDATTRIBUTENAME_DESCRIPTOR)
        field(CONDITIONS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(FILTER_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(READINESS_DESCRIPTOR)
        field(STATISTIC_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USEHISTORICALDATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTEDETAILS_DESCRIPTOR.index -> builder.attributeDetails = deserializeAttributeDetailsDocument(deserializer)
                CALCULATEDATTRIBUTENAME_DESCRIPTOR.index -> builder.calculatedAttributeName = deserializeString()
                CONDITIONS_DESCRIPTOR.index -> builder.conditions = deserializeConditionsDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                FILTER_DESCRIPTOR.index -> builder.filter = deserializeFilterDocument(deserializer)
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                READINESS_DESCRIPTOR.index -> builder.readiness = deserializeReadinessDocument(deserializer)
                STATISTIC_DESCRIPTOR.index -> builder.statistic = deserializeString().let { Statistic.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ReadinessStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USEHISTORICALDATA_DESCRIPTOR.index -> builder.useHistoricalData = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
