// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.paginators

import aws.sdk.kotlin.services.customerprofiles.CustomerProfilesClient
import aws.sdk.kotlin.services.customerprofiles.model.EventStreamSummary
import aws.sdk.kotlin.services.customerprofiles.model.EventTriggerSummaryItem
import aws.sdk.kotlin.services.customerprofiles.model.GetSimilarProfilesRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSimilarProfilesResponse
import aws.sdk.kotlin.services.customerprofiles.model.LayoutItem
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainLayoutsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainLayoutsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListEventStreamsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListEventStreamsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListEventTriggersRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListEventTriggersResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListObjectTypeAttributeItem
import aws.sdk.kotlin.services.customerprofiles.model.ListObjectTypeAttributesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListObjectTypeAttributesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListRuleBasedMatchesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListRuleBasedMatchesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListSegmentDefinitionsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListSegmentDefinitionsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListUploadJobsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListUploadJobsResponse
import aws.sdk.kotlin.services.customerprofiles.model.SegmentDefinitionItem
import aws.sdk.kotlin.services.customerprofiles.model.UploadJobItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetSimilarProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSimilarProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSimilarProfilesResponse]
 */
public fun CustomerProfilesClient.getSimilarProfilesPaginated(initialRequest: GetSimilarProfilesRequest): Flow<GetSimilarProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSimilarProfilesPaginated.getSimilarProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetSimilarProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSimilarProfilesResponse]
 */
public fun CustomerProfilesClient.getSimilarProfilesPaginated(block: GetSimilarProfilesRequest.Builder.() -> Unit): Flow<GetSimilarProfilesResponse> =
    getSimilarProfilesPaginated(GetSimilarProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getSimilarProfilesPaginated]
 * to access the nested member [Uuid]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Uuid]
 */
@JvmName("getSimilarProfilesResponseUuid")
public fun Flow<GetSimilarProfilesResponse>.profileIds(): Flow<String> =
    transform() { response ->
        response.profileIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainLayoutsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainLayoutsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainLayoutsResponse]
 */
public fun CustomerProfilesClient.listDomainLayoutsPaginated(initialRequest: ListDomainLayoutsRequest): Flow<ListDomainLayoutsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainLayoutsPaginated.listDomainLayouts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainLayoutsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainLayoutsResponse]
 */
public fun CustomerProfilesClient.listDomainLayoutsPaginated(block: ListDomainLayoutsRequest.Builder.() -> Unit): Flow<ListDomainLayoutsResponse> =
    listDomainLayoutsPaginated(ListDomainLayoutsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainLayoutsPaginated]
 * to access the nested member [LayoutItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LayoutItem]
 */
@JvmName("listDomainLayoutsResponseLayoutItem")
public fun Flow<ListDomainLayoutsResponse>.items(): Flow<LayoutItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventStreamsResponse]
 */
public fun CustomerProfilesClient.listEventStreamsPaginated(initialRequest: ListEventStreamsRequest): Flow<ListEventStreamsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventStreamsPaginated.listEventStreams(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventStreamsResponse]
 */
public fun CustomerProfilesClient.listEventStreamsPaginated(block: ListEventStreamsRequest.Builder.() -> Unit): Flow<ListEventStreamsResponse> =
    listEventStreamsPaginated(ListEventStreamsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventStreamsPaginated]
 * to access the nested member [EventStreamSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventStreamSummary]
 */
@JvmName("listEventStreamsResponseEventStreamSummary")
public fun Flow<ListEventStreamsResponse>.items(): Flow<EventStreamSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEventTriggersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventTriggersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTriggersResponse]
 */
public fun CustomerProfilesClient.listEventTriggersPaginated(initialRequest: ListEventTriggersRequest): Flow<ListEventTriggersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventTriggersPaginated.listEventTriggers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEventTriggersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTriggersResponse]
 */
public fun CustomerProfilesClient.listEventTriggersPaginated(block: ListEventTriggersRequest.Builder.() -> Unit): Flow<ListEventTriggersResponse> =
    listEventTriggersPaginated(ListEventTriggersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventTriggersPaginated]
 * to access the nested member [EventTriggerSummaryItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventTriggerSummaryItem]
 */
@JvmName("listEventTriggersResponseEventTriggerSummaryItem")
public fun Flow<ListEventTriggersResponse>.items(): Flow<EventTriggerSummaryItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListObjectTypeAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListObjectTypeAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectTypeAttributesResponse]
 */
public fun CustomerProfilesClient.listObjectTypeAttributesPaginated(initialRequest: ListObjectTypeAttributesRequest): Flow<ListObjectTypeAttributesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listObjectTypeAttributesPaginated.listObjectTypeAttributes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListObjectTypeAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectTypeAttributesResponse]
 */
public fun CustomerProfilesClient.listObjectTypeAttributesPaginated(block: ListObjectTypeAttributesRequest.Builder.() -> Unit): Flow<ListObjectTypeAttributesResponse> =
    listObjectTypeAttributesPaginated(ListObjectTypeAttributesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listObjectTypeAttributesPaginated]
 * to access the nested member [ListObjectTypeAttributeItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListObjectTypeAttributeItem]
 */
@JvmName("listObjectTypeAttributesResponseListObjectTypeAttributeItem")
public fun Flow<ListObjectTypeAttributesResponse>.items(): Flow<ListObjectTypeAttributeItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRuleBasedMatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRuleBasedMatchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleBasedMatchesResponse]
 */
public fun CustomerProfilesClient.listRuleBasedMatchesPaginated(initialRequest: ListRuleBasedMatchesRequest): Flow<ListRuleBasedMatchesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRuleBasedMatchesPaginated.listRuleBasedMatches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRuleBasedMatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleBasedMatchesResponse]
 */
public fun CustomerProfilesClient.listRuleBasedMatchesPaginated(block: ListRuleBasedMatchesRequest.Builder.() -> Unit): Flow<ListRuleBasedMatchesResponse> =
    listRuleBasedMatchesPaginated(ListRuleBasedMatchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRuleBasedMatchesPaginated]
 * to access the nested member [String1To255]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String1To255]
 */
@JvmName("listRuleBasedMatchesResponseString1To255")
public fun Flow<ListRuleBasedMatchesResponse>.matchIds(): Flow<String> =
    transform() { response ->
        response.matchIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSegmentDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSegmentDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSegmentDefinitionsResponse]
 */
public fun CustomerProfilesClient.listSegmentDefinitionsPaginated(initialRequest: ListSegmentDefinitionsRequest): Flow<ListSegmentDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSegmentDefinitionsPaginated.listSegmentDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSegmentDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSegmentDefinitionsResponse]
 */
public fun CustomerProfilesClient.listSegmentDefinitionsPaginated(block: ListSegmentDefinitionsRequest.Builder.() -> Unit): Flow<ListSegmentDefinitionsResponse> =
    listSegmentDefinitionsPaginated(ListSegmentDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSegmentDefinitionsPaginated]
 * to access the nested member [SegmentDefinitionItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SegmentDefinitionItem]
 */
@JvmName("listSegmentDefinitionsResponseSegmentDefinitionItem")
public fun Flow<ListSegmentDefinitionsResponse>.items(): Flow<SegmentDefinitionItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUploadJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUploadJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUploadJobsResponse]
 */
public fun CustomerProfilesClient.listUploadJobsPaginated(initialRequest: ListUploadJobsRequest): Flow<ListUploadJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUploadJobsPaginated.listUploadJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUploadJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUploadJobsResponse]
 */
public fun CustomerProfilesClient.listUploadJobsPaginated(block: ListUploadJobsRequest.Builder.() -> Unit): Flow<ListUploadJobsResponse> =
    listUploadJobsPaginated(ListUploadJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUploadJobsPaginated]
 * to access the nested member [UploadJobItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UploadJobItem]
 */
@JvmName("listUploadJobsResponseUploadJobItem")
public fun Flow<ListUploadJobsResponse>.items(): Flow<UploadJobItem> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
