// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchProfilesRequest private constructor(builder: Builder) {
    /**
     * A list of `AdditionalSearchKey` objects that are each searchable identifiers of a profile. Each `AdditionalSearchKey` object contains a `KeyName` and a list of `Values` associated with that specific key (i.e., a key-value(s) pair). These additional search keys will be used in conjunction with the `LogicalOperator` and the required `KeyName` and `Values` parameters to search for profiles that satisfy the search criteria.
     */
    public val additionalSearchKeys: List<AdditionalSearchKey>? = builder.additionalSearchKeys
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * Relationship between all specified search keys that will be used to search for profiles. This includes the required `KeyName` and `Values` parameters as well as any key-value(s) pairs specified in the `AdditionalSearchKeys` list.
     *
     * This parameter influences which profiles will be returned in the response in the following manner:
     * + `AND` - The response only includes profiles that match all of the search keys.
     * + `OR` - The response includes profiles that match at least one of the search keys.
     *
     * The `OR` relationship is the default behavior if this parameter is not included in the request.
     */
    public val logicalOperator: aws.sdk.kotlin.services.customerprofiles.model.LogicalOperator? = builder.logicalOperator
    /**
     * The maximum number of objects returned per page.
     *
     * The default is 20 if this parameter is not included in the request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token from the previous SearchProfiles API call.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A list of key values.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchProfilesRequest(")
        append("additionalSearchKeys=$additionalSearchKeys,")
        append("domainName=$domainName,")
        append("keyName=$keyName,")
        append("logicalOperator=$logicalOperator,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalSearchKeys?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (logicalOperator?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchProfilesRequest

        if (additionalSearchKeys != other.additionalSearchKeys) return false
        if (domainName != other.domainName) return false
        if (keyName != other.keyName) return false
        if (logicalOperator != other.logicalOperator) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `AdditionalSearchKey` objects that are each searchable identifiers of a profile. Each `AdditionalSearchKey` object contains a `KeyName` and a list of `Values` associated with that specific key (i.e., a key-value(s) pair). These additional search keys will be used in conjunction with the `LogicalOperator` and the required `KeyName` and `Values` parameters to search for profiles that satisfy the search criteria.
         */
        public var additionalSearchKeys: List<AdditionalSearchKey>? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.
         */
        public var keyName: kotlin.String? = null
        /**
         * Relationship between all specified search keys that will be used to search for profiles. This includes the required `KeyName` and `Values` parameters as well as any key-value(s) pairs specified in the `AdditionalSearchKeys` list.
         *
         * This parameter influences which profiles will be returned in the response in the following manner:
         * + `AND` - The response only includes profiles that match all of the search keys.
         * + `OR` - The response includes profiles that match at least one of the search keys.
         *
         * The `OR` relationship is the default behavior if this parameter is not included in the request.
         */
        public var logicalOperator: aws.sdk.kotlin.services.customerprofiles.model.LogicalOperator? = null
        /**
         * The maximum number of objects returned per page.
         *
         * The default is 20 if this parameter is not included in the request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token from the previous SearchProfiles API call.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A list of key values.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest) : this() {
            this.additionalSearchKeys = x.additionalSearchKeys
            this.domainName = x.domainName
            this.keyName = x.keyName
            this.logicalOperator = x.logicalOperator
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest = SearchProfilesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
