// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The standard profile of a customer.
 */
public class Profile private constructor(builder: Builder) {
    /**
     * An account number that you have assigned to the customer.
     */
    public val accountNumber: kotlin.String? = builder.accountNumber
    /**
     * Any additional information relevant to the customer’s profile.
     */
    public val additionalInformation: kotlin.String? = builder.additionalInformation
    /**
     * A generic address associated with the customer that is not mailing, shipping, or billing.
     */
    public val address: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.address
    /**
     * A key value pair of attributes of a customer profile.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The customer’s billing address.
     */
    public val billingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.billingAddress
    /**
     * The customer’s birth date.
     */
    public val birthDate: kotlin.String? = builder.birthDate
    /**
     * The customer’s business email address.
     */
    public val businessEmailAddress: kotlin.String? = builder.businessEmailAddress
    /**
     * The name of the customer’s business.
     */
    public val businessName: kotlin.String? = builder.businessName
    /**
     * The customer’s home phone number.
     */
    public val businessPhoneNumber: kotlin.String? = builder.businessPhoneNumber
    /**
     * The customer’s email address, which has not been specified as a personal or business address.
     */
    public val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * The customer’s first name.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * A list of items used to find a profile returned in a [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) response. An item is a key-value(s) pair that matches an attribute in the profile.
     *
     * If the optional `AdditionalSearchKeys` parameter was included in the [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) request, the `FoundByItems` list should be interpreted based on the `LogicalOperator` used in the request:
     * + `AND` - The profile included in the response matched all of the search keys specified in the request. The `FoundByItems` will include all of the key-value(s) pairs that were specified in the request (as this is a requirement of `AND` search logic).
     * + `OR` - The profile included in the response matched at least one of the search keys specified in the request. The `FoundByItems` will include each of the key-value(s) pairs that the profile was found by.
     *
     * The `OR` relationship is the default behavior if the `LogicalOperator` parameter is not included in the [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) request.
     */
    public val foundByItems: List<FoundByKeyValue>? = builder.foundByItems
    /**
     * The gender with which the customer identifies.
     */
    public val gender: aws.sdk.kotlin.services.customerprofiles.model.Gender? = builder.gender
    /**
     * An alternative to Gender which accepts any string as input.
     */
    public val genderString: kotlin.String? = builder.genderString
    /**
     * The customer’s home phone number.
     */
    public val homePhoneNumber: kotlin.String? = builder.homePhoneNumber
    /**
     * The customer’s last name.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The customer’s mailing address.
     */
    public val mailingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.mailingAddress
    /**
     * The customer’s middle name.
     */
    public val middleName: kotlin.String? = builder.middleName
    /**
     * The customer’s mobile phone number.
     */
    public val mobilePhoneNumber: kotlin.String? = builder.mobilePhoneNumber
    /**
     * The type of profile used to describe the customer.
     */
    public val partyType: aws.sdk.kotlin.services.customerprofiles.model.PartyType? = builder.partyType
    /**
     * An alternative to PartyType which accepts any string as input.
     */
    public val partyTypeString: kotlin.String? = builder.partyTypeString
    /**
     * The customer’s personal email address.
     */
    public val personalEmailAddress: kotlin.String? = builder.personalEmailAddress
    /**
     * The customer's phone number, which has not been specified as a mobile, home, or business number.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The unique identifier of a customer profile.
     */
    public val profileId: kotlin.String? = builder.profileId
    /**
     * The customer’s shipping address.
     */
    public val shippingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.shippingAddress

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.Profile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Profile(")
        append("accountNumber=*** Sensitive Data Redacted ***,")
        append("additionalInformation=*** Sensitive Data Redacted ***,")
        append("address=*** Sensitive Data Redacted ***,")
        append("attributes=*** Sensitive Data Redacted ***,")
        append("billingAddress=*** Sensitive Data Redacted ***,")
        append("birthDate=*** Sensitive Data Redacted ***,")
        append("businessEmailAddress=*** Sensitive Data Redacted ***,")
        append("businessName=*** Sensitive Data Redacted ***,")
        append("businessPhoneNumber=*** Sensitive Data Redacted ***,")
        append("emailAddress=*** Sensitive Data Redacted ***,")
        append("firstName=*** Sensitive Data Redacted ***,")
        append("foundByItems=$foundByItems,")
        append("gender=*** Sensitive Data Redacted ***,")
        append("genderString=*** Sensitive Data Redacted ***,")
        append("homePhoneNumber=*** Sensitive Data Redacted ***,")
        append("lastName=*** Sensitive Data Redacted ***,")
        append("mailingAddress=*** Sensitive Data Redacted ***,")
        append("middleName=*** Sensitive Data Redacted ***,")
        append("mobilePhoneNumber=*** Sensitive Data Redacted ***,")
        append("partyType=*** Sensitive Data Redacted ***,")
        append("partyTypeString=*** Sensitive Data Redacted ***,")
        append("personalEmailAddress=*** Sensitive Data Redacted ***,")
        append("phoneNumber=*** Sensitive Data Redacted ***,")
        append("profileId=$profileId,")
        append("shippingAddress=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountNumber?.hashCode() ?: 0
        result = 31 * result + (additionalInformation?.hashCode() ?: 0)
        result = 31 * result + (address?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (billingAddress?.hashCode() ?: 0)
        result = 31 * result + (birthDate?.hashCode() ?: 0)
        result = 31 * result + (businessEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (businessName?.hashCode() ?: 0)
        result = 31 * result + (businessPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (foundByItems?.hashCode() ?: 0)
        result = 31 * result + (gender?.hashCode() ?: 0)
        result = 31 * result + (genderString?.hashCode() ?: 0)
        result = 31 * result + (homePhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (mailingAddress?.hashCode() ?: 0)
        result = 31 * result + (middleName?.hashCode() ?: 0)
        result = 31 * result + (mobilePhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (partyType?.hashCode() ?: 0)
        result = 31 * result + (partyTypeString?.hashCode() ?: 0)
        result = 31 * result + (personalEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (profileId?.hashCode() ?: 0)
        result = 31 * result + (shippingAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Profile

        if (accountNumber != other.accountNumber) return false
        if (additionalInformation != other.additionalInformation) return false
        if (address != other.address) return false
        if (attributes != other.attributes) return false
        if (billingAddress != other.billingAddress) return false
        if (birthDate != other.birthDate) return false
        if (businessEmailAddress != other.businessEmailAddress) return false
        if (businessName != other.businessName) return false
        if (businessPhoneNumber != other.businessPhoneNumber) return false
        if (emailAddress != other.emailAddress) return false
        if (firstName != other.firstName) return false
        if (foundByItems != other.foundByItems) return false
        if (gender != other.gender) return false
        if (genderString != other.genderString) return false
        if (homePhoneNumber != other.homePhoneNumber) return false
        if (lastName != other.lastName) return false
        if (mailingAddress != other.mailingAddress) return false
        if (middleName != other.middleName) return false
        if (mobilePhoneNumber != other.mobilePhoneNumber) return false
        if (partyType != other.partyType) return false
        if (partyTypeString != other.partyTypeString) return false
        if (personalEmailAddress != other.personalEmailAddress) return false
        if (phoneNumber != other.phoneNumber) return false
        if (profileId != other.profileId) return false
        if (shippingAddress != other.shippingAddress) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.Profile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An account number that you have assigned to the customer.
         */
        public var accountNumber: kotlin.String? = null
        /**
         * Any additional information relevant to the customer’s profile.
         */
        public var additionalInformation: kotlin.String? = null
        /**
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         */
        public var address: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * A key value pair of attributes of a customer profile.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The customer’s billing address.
         */
        public var billingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * The customer’s birth date.
         */
        public var birthDate: kotlin.String? = null
        /**
         * The customer’s business email address.
         */
        public var businessEmailAddress: kotlin.String? = null
        /**
         * The name of the customer’s business.
         */
        public var businessName: kotlin.String? = null
        /**
         * The customer’s home phone number.
         */
        public var businessPhoneNumber: kotlin.String? = null
        /**
         * The customer’s email address, which has not been specified as a personal or business address.
         */
        public var emailAddress: kotlin.String? = null
        /**
         * The customer’s first name.
         */
        public var firstName: kotlin.String? = null
        /**
         * A list of items used to find a profile returned in a [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) response. An item is a key-value(s) pair that matches an attribute in the profile.
         *
         * If the optional `AdditionalSearchKeys` parameter was included in the [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) request, the `FoundByItems` list should be interpreted based on the `LogicalOperator` used in the request:
         * + `AND` - The profile included in the response matched all of the search keys specified in the request. The `FoundByItems` will include all of the key-value(s) pairs that were specified in the request (as this is a requirement of `AND` search logic).
         * + `OR` - The profile included in the response matched at least one of the search keys specified in the request. The `FoundByItems` will include each of the key-value(s) pairs that the profile was found by.
         *
         * The `OR` relationship is the default behavior if the `LogicalOperator` parameter is not included in the [SearchProfiles](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html) request.
         */
        public var foundByItems: List<FoundByKeyValue>? = null
        /**
         * The gender with which the customer identifies.
         */
        public var gender: aws.sdk.kotlin.services.customerprofiles.model.Gender? = null
        /**
         * An alternative to Gender which accepts any string as input.
         */
        public var genderString: kotlin.String? = null
        /**
         * The customer’s home phone number.
         */
        public var homePhoneNumber: kotlin.String? = null
        /**
         * The customer’s last name.
         */
        public var lastName: kotlin.String? = null
        /**
         * The customer’s mailing address.
         */
        public var mailingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * The customer’s middle name.
         */
        public var middleName: kotlin.String? = null
        /**
         * The customer’s mobile phone number.
         */
        public var mobilePhoneNumber: kotlin.String? = null
        /**
         * The type of profile used to describe the customer.
         */
        public var partyType: aws.sdk.kotlin.services.customerprofiles.model.PartyType? = null
        /**
         * An alternative to PartyType which accepts any string as input.
         */
        public var partyTypeString: kotlin.String? = null
        /**
         * The customer’s personal email address.
         */
        public var personalEmailAddress: kotlin.String? = null
        /**
         * The customer's phone number, which has not been specified as a mobile, home, or business number.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The unique identifier of a customer profile.
         */
        public var profileId: kotlin.String? = null
        /**
         * The customer’s shipping address.
         */
        public var shippingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.Profile) : this() {
            this.accountNumber = x.accountNumber
            this.additionalInformation = x.additionalInformation
            this.address = x.address
            this.attributes = x.attributes
            this.billingAddress = x.billingAddress
            this.birthDate = x.birthDate
            this.businessEmailAddress = x.businessEmailAddress
            this.businessName = x.businessName
            this.businessPhoneNumber = x.businessPhoneNumber
            this.emailAddress = x.emailAddress
            this.firstName = x.firstName
            this.foundByItems = x.foundByItems
            this.gender = x.gender
            this.genderString = x.genderString
            this.homePhoneNumber = x.homePhoneNumber
            this.lastName = x.lastName
            this.mailingAddress = x.mailingAddress
            this.middleName = x.middleName
            this.mobilePhoneNumber = x.mobilePhoneNumber
            this.partyType = x.partyType
            this.partyTypeString = x.partyTypeString
            this.personalEmailAddress = x.personalEmailAddress
            this.phoneNumber = x.phoneNumber
            this.profileId = x.profileId
            this.shippingAddress = x.shippingAddress
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.Profile = Profile(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        public fun address(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.address = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        public fun billingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.billingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        public fun mailingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.mailingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        public fun shippingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.shippingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
