// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The layout object that contains LayoutDefinitionName, Description, DisplayName, IsDefault, LayoutType, Tags, CreatedAt, LastUpdatedAt
 */
public class LayoutItem private constructor(builder: Builder) {
    /**
     * The timestamp of when the layout was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the layout
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The display name of the layout
     */
    public val displayName: kotlin.String = requireNotNull(builder.displayName) { "A non-null value must be provided for displayName" }
    /**
     * If set to true for a layout, this layout will be used by default to view data. If set to false, then layout will not be used by default but it can be used to view data by explicit selection on UI.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The timestamp of when the layout was most recently updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The unique name of the layout.
     */
    public val layoutDefinitionName: kotlin.String = requireNotNull(builder.layoutDefinitionName) { "A non-null value must be provided for layoutDefinitionName" }
    /**
     * The type of layout that can be used to view data under customer profiles domain.
     */
    public val layoutType: aws.sdk.kotlin.services.customerprofiles.model.LayoutType = requireNotNull(builder.layoutType) { "A non-null value must be provided for layoutType" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.LayoutItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LayoutItem(")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=$displayName,")
        append("isDefault=$isDefault,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("layoutDefinitionName=$layoutDefinitionName,")
        append("layoutType=$layoutType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (description.hashCode())
        result = 31 * result + (displayName.hashCode())
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (layoutDefinitionName.hashCode())
        result = 31 * result + (layoutType.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LayoutItem

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (isDefault != other.isDefault) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (layoutDefinitionName != other.layoutDefinitionName) return false
        if (layoutType != other.layoutType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.LayoutItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the layout was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the layout
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the layout
         */
        public var displayName: kotlin.String? = null
        /**
         * If set to true for a layout, this layout will be used by default to view data. If set to false, then layout will not be used by default but it can be used to view data by explicit selection on UI.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The timestamp of when the layout was most recently updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique name of the layout.
         */
        public var layoutDefinitionName: kotlin.String? = null
        /**
         * The type of layout that can be used to view data under customer profiles domain.
         */
        public var layoutType: aws.sdk.kotlin.services.customerprofiles.model.LayoutType? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.LayoutItem) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.displayName = x.displayName
            this.isDefault = x.isDefault
            this.lastUpdatedAt = x.lastUpdatedAt
            this.layoutDefinitionName = x.layoutDefinitionName
            this.layoutType = x.layoutType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.LayoutItem = LayoutItem(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (displayName == null) displayName = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (layoutDefinitionName == null) layoutDefinitionName = ""
            if (layoutType == null) layoutType = LayoutType.SdkUnknown("no value provided")
            return this
        }
    }
}
