// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetIntegrationResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the domain was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * A list of unique names for active event triggers associated with the integration. This list would be empty if no Event Trigger is associated with the integration.
     */
    public val eventTriggerNames: List<String>? = builder.eventTriggerNames
    /**
     * Boolean that shows if the Flow that's associated with the Integration is created in Amazon Appflow, or with ObjectTypeName equals _unstructured via API/CLI in flowDefinition.
     */
    public val isUnstructured: kotlin.Boolean? = builder.isUnstructured
    /**
     * The timestamp of when the domain was most recently edited.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The name of the profile object type.
     */
    public val objectTypeName: kotlin.String? = builder.objectTypeName
    /**
     * A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an `ObjectTypeName` (template) used to ingest the event. It supports the following event types: `SegmentIdentify`, `ShopifyCreateCustomers`, `ShopifyUpdateCustomers`, `ShopifyCreateDraftOrders`, `ShopifyUpdateDraftOrders`, `ShopifyCreateOrders`, and `ShopifyUpdatedOrders`.
     */
    public val objectTypeNames: Map<String, String>? = builder.objectTypeNames
    /**
     * The Amazon Resource Name (ARN) of the IAM role. The Integration uses this role to make Customer Profiles requests on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The URI of the S3 bucket or any other type of data source.
     */
    public val uri: kotlin.String = requireNotNull(builder.uri) { "A non-null value must be provided for uri" }
    /**
     * Unique identifier for the workflow.
     */
    public val workflowId: kotlin.String? = builder.workflowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetIntegrationResponse(")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("eventTriggerNames=$eventTriggerNames,")
        append("isUnstructured=$isUnstructured,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("objectTypeName=$objectTypeName,")
        append("objectTypeNames=$objectTypeNames,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("uri=$uri,")
        append("workflowId=$workflowId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (eventTriggerNames?.hashCode() ?: 0)
        result = 31 * result + (isUnstructured?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (objectTypeName?.hashCode() ?: 0)
        result = 31 * result + (objectTypeNames?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uri.hashCode())
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetIntegrationResponse

        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (eventTriggerNames != other.eventTriggerNames) return false
        if (isUnstructured != other.isUnstructured) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (objectTypeName != other.objectTypeName) return false
        if (objectTypeNames != other.objectTypeNames) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (uri != other.uri) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the domain was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * A list of unique names for active event triggers associated with the integration. This list would be empty if no Event Trigger is associated with the integration.
         */
        public var eventTriggerNames: List<String>? = null
        /**
         * Boolean that shows if the Flow that's associated with the Integration is created in Amazon Appflow, or with ObjectTypeName equals _unstructured via API/CLI in flowDefinition.
         */
        public var isUnstructured: kotlin.Boolean? = null
        /**
         * The timestamp of when the domain was most recently edited.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the profile object type.
         */
        public var objectTypeName: kotlin.String? = null
        /**
         * A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an `ObjectTypeName` (template) used to ingest the event. It supports the following event types: `SegmentIdentify`, `ShopifyCreateCustomers`, `ShopifyUpdateCustomers`, `ShopifyCreateDraftOrders`, `ShopifyUpdateDraftOrders`, `ShopifyCreateOrders`, and `ShopifyUpdatedOrders`.
         */
        public var objectTypeNames: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role. The Integration uses this role to make Customer Profiles requests on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The URI of the S3 bucket or any other type of data source.
         */
        public var uri: kotlin.String? = null
        /**
         * Unique identifier for the workflow.
         */
        public var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationResponse) : this() {
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.eventTriggerNames = x.eventTriggerNames
            this.isUnstructured = x.isUnstructured
            this.lastUpdatedAt = x.lastUpdatedAt
            this.objectTypeName = x.objectTypeName
            this.objectTypeNames = x.objectTypeNames
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.uri = x.uri
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationResponse = GetIntegrationResponse(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (domainName == null) domainName = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (uri == null) uri = ""
            return this
        }
    }
}
