// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration settings for how to perform the auto-merging of profiles.
 */
public class AutoMerging private constructor(builder: Builder) {
    /**
     * How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` (and that is the matching criteria), which `EmailAddress` should be used?
     */
    public val conflictResolution: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution? = builder.conflictResolution
    /**
     * A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
     */
    public val consolidation: aws.sdk.kotlin.services.customerprofiles.model.Consolidation? = builder.consolidation
    /**
     * The flag that enables the auto-merging of duplicate profiles.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
     */
    public val minAllowedConfidenceScoreForMerging: kotlin.Double? = builder.minAllowedConfidenceScoreForMerging

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.AutoMerging = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMerging(")
        append("conflictResolution=$conflictResolution,")
        append("consolidation=$consolidation,")
        append("enabled=$enabled,")
        append("minAllowedConfidenceScoreForMerging=$minAllowedConfidenceScoreForMerging")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictResolution?.hashCode() ?: 0
        result = 31 * result + (consolidation?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (minAllowedConfidenceScoreForMerging?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMerging

        if (conflictResolution != other.conflictResolution) return false
        if (consolidation != other.consolidation) return false
        if (enabled != other.enabled) return false
        if (!(minAllowedConfidenceScoreForMerging?.equals(other.minAllowedConfidenceScoreForMerging) ?: (other.minAllowedConfidenceScoreForMerging == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.AutoMerging = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * How the auto-merging process should resolve conflicts between different profiles. For example, if Profile A and Profile B have the same `FirstName` and `LastName` (and that is the matching criteria), which `EmailAddress` should be used?
         */
        public var conflictResolution: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution? = null
        /**
         * A list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged.
         */
        public var consolidation: aws.sdk.kotlin.services.customerprofiles.model.Consolidation? = null
        /**
         * The flag that enables the auto-merging of duplicate profiles.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
         */
        public var minAllowedConfidenceScoreForMerging: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.AutoMerging) : this() {
            this.conflictResolution = x.conflictResolution
            this.consolidation = x.consolidation
            this.enabled = x.enabled
            this.minAllowedConfidenceScoreForMerging = x.minAllowedConfidenceScoreForMerging
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.AutoMerging = AutoMerging(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution] inside the given [block]
         */
        public fun conflictResolution(block: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution.Builder.() -> kotlin.Unit) {
            this.conflictResolution = aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Consolidation] inside the given [block]
         */
        public fun consolidation(block: aws.sdk.kotlin.services.customerprofiles.model.Consolidation.Builder.() -> kotlin.Unit) {
            this.consolidation = aws.sdk.kotlin.services.customerprofiles.model.Consolidation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
