// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeField
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey
import aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutProfileObjectTypeOperationSerializer: HttpSerializer.NonStreaming<PutProfileObjectTypeRequest> {
    override fun serialize(context: ExecutionContext, input: PutProfileObjectTypeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            requireNotNull(input.objectTypeName) { "objectTypeName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("object-types"))
                add(PercentEncoding.SmithyLabel.encode(input.objectTypeName))
            }
        }

        val payload = serializePutProfileObjectTypeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutProfileObjectTypeOperationBody(context: ExecutionContext, input: PutProfileObjectTypeRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWPROFILECREATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowProfileCreation"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKey"))
    val EXPIRATIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ExpirationDays"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Fields"))
    val KEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Keys"))
    val KEYS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val MAXPROFILEOBJECTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxProfileObjectCount"))
    val SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLastUpdatedTimestampFormat"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWPROFILECREATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENCRYPTIONKEY_DESCRIPTOR)
        field(EXPIRATIONDAYS_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(KEYS_DESCRIPTOR)
        field(MAXPROFILEOBJECTCOUNT_DESCRIPTOR)
        field(SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.allowProfileCreation?.let { field(ALLOWPROFILECREATION_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.encryptionKey?.let { field(ENCRYPTIONKEY_DESCRIPTOR, it) }
        input.expirationDays?.let { field(EXPIRATIONDAYS_DESCRIPTOR, it) }
        if (input.fields != null) {
            mapField(FIELDS_DESCRIPTOR) {
                input.fields.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeObjectTypeFieldDocument)) }
            }
        }
        if (input.keys != null) {
            mapField(KEYS_DESCRIPTOR) {
                input.keys.forEach { (key, value) ->
                    listEntry(key, KEYS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeSdkSerializable(asSdkSerializable(el1, ::serializeObjectTypeKeyDocument))
                        }
                    }
                }
            }
        }
        input.maxProfileObjectCount?.let { field(MAXPROFILEOBJECTCOUNT_DESCRIPTOR, it) }
        input.sourceLastUpdatedTimestampFormat?.let { field(SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.templateId?.let { field(TEMPLATEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
