// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition
import aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PutIntegrationOperationSerializer: HttpSerializer.NonStreaming<PutIntegrationRequest> {
    override fun serialize(context: ExecutionContext, input: PutIntegrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("integrations"))
            }
        }

        val payload = serializePutIntegrationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutIntegrationOperationBody(context: ExecutionContext, input: PutIntegrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val EVENTTRIGGERNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventTriggerNames"))
    val FLOWDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FlowDefinition"))
    val OBJECTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectTypeName"))
    val OBJECTTYPENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ObjectTypeNames"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val URI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Uri"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTTRIGGERNAMES_DESCRIPTOR)
        field(FLOWDEFINITION_DESCRIPTOR)
        field(OBJECTTYPENAME_DESCRIPTOR)
        field(OBJECTTYPENAMES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(URI_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.eventTriggerNames != null) {
            listField(EVENTTRIGGERNAMES_DESCRIPTOR) {
                for (el0 in input.eventTriggerNames) {
                    serializeString(el0)
                }
            }
        }
        input.flowDefinition?.let { field(FLOWDEFINITION_DESCRIPTOR, it, ::serializeFlowDefinitionDocument) }
        input.objectTypeName?.let { field(OBJECTTYPENAME_DESCRIPTOR, it) }
        if (input.objectTypeNames != null) {
            mapField(OBJECTTYPENAMES_DESCRIPTOR) {
                input.objectTypeNames.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.uri?.let { field(URI_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
