// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobPathResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetUploadJobPathOperationDeserializer: HttpDeserializer.NonStreaming<GetUploadJobPathResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetUploadJobPathResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetUploadJobPathError(context, call, payload)
        }
        val builder = GetUploadJobPathResponse.Builder()

        if (payload != null) {
            deserializeGetUploadJobPathOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetUploadJobPathError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUploadJobPathOperationBody(builder: GetUploadJobPathResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val VALIDUNTIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ValidUntil"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(VALIDUNTIL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLIENTTOKEN_DESCRIPTOR.index -> builder.clientToken = deserializeString()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                VALIDUNTIL_DESCRIPTOR.index -> builder.validUntil = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
