// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentMembershipResponse
import aws.sdk.kotlin.services.customerprofiles.model.ProfileQueryFailures
import aws.sdk.kotlin.services.customerprofiles.model.ProfileQueryResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSegmentMembershipOperationDeserializer: HttpDeserializer.NonStreaming<GetSegmentMembershipResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSegmentMembershipResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSegmentMembershipError(context, call, payload)
        }
        val builder = GetSegmentMembershipResponse.Builder()

        if (payload != null) {
            deserializeGetSegmentMembershipOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSegmentMembershipError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSegmentMembershipOperationBody(builder: GetSegmentMembershipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failures"))
    val PROFILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Profiles"))
    val SEGMENTDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SegmentDefinitionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILURES_DESCRIPTOR)
        field(PROFILES_DESCRIPTOR)
        field(SEGMENTDEFINITIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILURES_DESCRIPTOR.index -> builder.failures =
                    deserializer.deserializeList(FAILURES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProfileQueryFailures>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProfileQueryFailuresDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROFILES_DESCRIPTOR.index -> builder.profiles =
                    deserializer.deserializeList(PROFILES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProfileQueryResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProfileQueryResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SEGMENTDEFINITIONNAME_DESCRIPTOR.index -> builder.segmentDefinitionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
