// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.AutoMerging
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.ExportingLocation
import aws.sdk.kotlin.services.customerprofiles.model.GetIdentityResolutionJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.IdentityResolutionJobStatus
import aws.sdk.kotlin.services.customerprofiles.model.JobStats
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetIdentityResolutionJobOperationDeserializer: HttpDeserializer.NonStreaming<GetIdentityResolutionJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetIdentityResolutionJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIdentityResolutionJobError(context, call, payload)
        }
        val builder = GetIdentityResolutionJobResponse.Builder()

        if (payload != null) {
            deserializeGetIdentityResolutionJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetIdentityResolutionJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIdentityResolutionJobOperationBody(builder: GetIdentityResolutionJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMERGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMerging"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val EXPORTINGLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExportingLocation"))
    val JOBENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("JobEndTime"))
    val JOBEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("JobExpirationTime"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("JobStartTime"))
    val JOBSTATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobStats"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMERGING_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(EXPORTINGLOCATION_DESCRIPTOR)
        field(JOBENDTIME_DESCRIPTOR)
        field(JOBEXPIRATIONTIME_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTARTTIME_DESCRIPTOR)
        field(JOBSTATS_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMERGING_DESCRIPTOR.index -> builder.autoMerging = deserializeAutoMergingDocument(deserializer)
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                EXPORTINGLOCATION_DESCRIPTOR.index -> builder.exportingLocation = deserializeExportingLocationDocument(deserializer)
                JOBENDTIME_DESCRIPTOR.index -> builder.jobEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBEXPIRATIONTIME_DESCRIPTOR.index -> builder.jobExpirationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTARTTIME_DESCRIPTOR.index -> builder.jobStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                JOBSTATS_DESCRIPTOR.index -> builder.jobStats = deserializeJobStatsDocument(deserializer)
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { IdentityResolutionJobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
