// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse
import aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class CreateDomainOperationDeserializer: HttpDeserializer.NonStreaming<CreateDomainResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDomainError(context, call, payload)
        }
        val builder = CreateDomainResponse.Builder()

        if (payload != null) {
            deserializeCreateDomainOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDomainError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDomainOperationBody(builder: CreateDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DEADLETTERQUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeadLetterQueueUrl"))
    val DEFAULTENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultEncryptionKey"))
    val DEFAULTEXPIRATIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DefaultExpirationDays"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val MATCHING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Matching"))
    val RULEBASEDMATCHING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleBasedMatching"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DEADLETTERQUEUEURL_DESCRIPTOR)
        field(DEFAULTENCRYPTIONKEY_DESCRIPTOR)
        field(DEFAULTEXPIRATIONDAYS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(MATCHING_DESCRIPTOR)
        field(RULEBASEDMATCHING_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEADLETTERQUEUEURL_DESCRIPTOR.index -> builder.deadLetterQueueUrl = deserializeString()
                DEFAULTENCRYPTIONKEY_DESCRIPTOR.index -> builder.defaultEncryptionKey = deserializeString()
                DEFAULTEXPIRATIONDAYS_DESCRIPTOR.index -> builder.defaultExpirationDays = deserializeInt()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MATCHING_DESCRIPTOR.index -> builder.matching = deserializeMatchingResponseDocument(deserializer)
                RULEBASEDMATCHING_DESCRIPTOR.index -> builder.ruleBasedMatching = deserializeRuleBasedMatchingResponseDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
