// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.AttributeDetails
import aws.sdk.kotlin.services.customerprofiles.model.Conditions
import aws.sdk.kotlin.services.customerprofiles.model.CreateCalculatedAttributeDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.Filter
import aws.sdk.kotlin.services.customerprofiles.model.Statistic
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateCalculatedAttributeDefinitionOperationSerializer: HttpSerializer.NonStreaming<CreateCalculatedAttributeDefinitionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateCalculatedAttributeDefinitionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            requireNotNull(input.calculatedAttributeName) { "calculatedAttributeName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("calculated-attributes"))
                add(PercentEncoding.SmithyLabel.encode(input.calculatedAttributeName))
            }
        }

        val payload = serializeCreateCalculatedAttributeDefinitionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCalculatedAttributeDefinitionOperationBody(context: ExecutionContext, input: CreateCalculatedAttributeDefinitionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeDetails"))
    val CONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Conditions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val FILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filter"))
    val STATISTIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Statistic"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val USEHISTORICALDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseHistoricalData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEDETAILS_DESCRIPTOR)
        field(CONDITIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(FILTER_DESCRIPTOR)
        field(STATISTIC_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USEHISTORICALDATA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributeDetails?.let { field(ATTRIBUTEDETAILS_DESCRIPTOR, it, ::serializeAttributeDetailsDocument) }
        input.conditions?.let { field(CONDITIONS_DESCRIPTOR, it, ::serializeConditionsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.filter?.let { field(FILTER_DESCRIPTOR, it, ::serializeFilterDocument) }
        input.statistic?.let { field(STATISTIC_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.useHistoricalData?.let { field(USEHISTORICALDATA_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
