// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileError
import aws.sdk.kotlin.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.CalculatedAttributeValue
import aws.sdk.kotlin.services.customerprofiles.model.ConditionOverrides
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetCalculatedAttributeForProfileOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetCalculatedAttributeForProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetCalculatedAttributeForProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetCalculatedAttributeForProfileError(context, call, payload)
        }
        val builder = BatchGetCalculatedAttributeForProfileResponse.Builder()

        if (payload != null) {
            deserializeBatchGetCalculatedAttributeForProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetCalculatedAttributeForProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetCalculatedAttributeForProfileOperationBody(builder: BatchGetCalculatedAttributeForProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CALCULATEDATTRIBUTEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CalculatedAttributeValues"))
    val CONDITIONOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConditionOverrides"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CALCULATEDATTRIBUTEVALUES_DESCRIPTOR)
        field(CONDITIONOVERRIDES_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CALCULATEDATTRIBUTEVALUES_DESCRIPTOR.index -> builder.calculatedAttributeValues =
                    deserializer.deserializeList(CALCULATEDATTRIBUTEVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<CalculatedAttributeValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCalculatedAttributeValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONDITIONOVERRIDES_DESCRIPTOR.index -> builder.conditionOverrides = deserializeConditionOverridesDocument(deserializer)
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetCalculatedAttributeForProfileError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetCalculatedAttributeForProfileErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
