// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the configuration of the source connector used in the flow.
 */
public class SourceFlowConfig private constructor(builder: Builder) {
    /**
     * The name of the AppFlow connector profile. This name must be unique for each connector profile in the AWS account.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The type of connector, such as Salesforce, Marketo, and so on.
     */
    public val connectorType: aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorType = requireNotNull(builder.connectorType) { "A non-null value must be provided for connectorType" }
    /**
     * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
     */
    public val incrementalPullConfig: aws.sdk.kotlin.services.customerprofiles.model.IncrementalPullConfig? = builder.incrementalPullConfig
    /**
     * Specifies the information that is required to query a particular source connector.
     */
    public val sourceConnectorProperties: aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorProperties? = builder.sourceConnectorProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceFlowConfig(")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorType=$connectorType,")
        append("incrementalPullConfig=$incrementalPullConfig,")
        append("sourceConnectorProperties=$sourceConnectorProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectorProfileName?.hashCode() ?: 0
        result = 31 * result + (connectorType.hashCode())
        result = 31 * result + (incrementalPullConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceConnectorProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceFlowConfig

        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorType != other.connectorType) return false
        if (incrementalPullConfig != other.incrementalPullConfig) return false
        if (sourceConnectorProperties != other.sourceConnectorProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the AppFlow connector profile. This name must be unique for each connector profile in the AWS account.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The type of connector, such as Salesforce, Marketo, and so on.
         */
        public var connectorType: aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorType? = null
        /**
         * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
         */
        public var incrementalPullConfig: aws.sdk.kotlin.services.customerprofiles.model.IncrementalPullConfig? = null
        /**
         * Specifies the information that is required to query a particular source connector.
         */
        public var sourceConnectorProperties: aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig) : this() {
            this.connectorProfileName = x.connectorProfileName
            this.connectorType = x.connectorType
            this.incrementalPullConfig = x.incrementalPullConfig
            this.sourceConnectorProperties = x.sourceConnectorProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig = SourceFlowConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.IncrementalPullConfig] inside the given [block]
         */
        public fun incrementalPullConfig(block: aws.sdk.kotlin.services.customerprofiles.model.IncrementalPullConfig.Builder.() -> kotlin.Unit) {
            this.incrementalPullConfig = aws.sdk.kotlin.services.customerprofiles.model.IncrementalPullConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorProperties] inside the given [block]
         */
        public fun sourceConnectorProperties(block: aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorProperties.Builder.() -> kotlin.Unit) {
            this.sourceConnectorProperties = aws.sdk.kotlin.services.customerprofiles.model.SourceConnectorProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (connectorType == null) connectorType = SourceConnectorType.SdkUnknown("no value provided")
            return this
        }
    }
}
