// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies the configuration details of a scheduled-trigger flow that you define. Currently, these settings only apply to the scheduled-trigger type.
 */
public class ScheduledTriggerProperties private constructor(builder: Builder) {
    /**
     * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
     */
    public val dataPullMode: aws.sdk.kotlin.services.customerprofiles.model.DataPullMode? = builder.dataPullMode
    /**
     * Specifies the date range for the records to import from the connector in the first flow run.
     */
    public val firstExecutionFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.firstExecutionFrom
    /**
     * Specifies the scheduled end time for a scheduled-trigger flow.
     */
    public val scheduleEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduleEndTime
    /**
     * The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes).
     */
    public val scheduleExpression: kotlin.String = requireNotNull(builder.scheduleExpression) { "A non-null value must be provided for scheduleExpression" }
    /**
     * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
     */
    public val scheduleOffset: kotlin.Long? = builder.scheduleOffset
    /**
     * Specifies the scheduled start time for a scheduled-trigger flow.
     */
    public val scheduleStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduleStartTime
    /**
     * Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.ScheduledTriggerProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledTriggerProperties(")
        append("dataPullMode=$dataPullMode,")
        append("firstExecutionFrom=$firstExecutionFrom,")
        append("scheduleEndTime=$scheduleEndTime,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleStartTime=$scheduleStartTime,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataPullMode?.hashCode() ?: 0
        result = 31 * result + (firstExecutionFrom?.hashCode() ?: 0)
        result = 31 * result + (scheduleEndTime?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression.hashCode())
        result = 31 * result + (scheduleOffset?.hashCode() ?: 0)
        result = 31 * result + (scheduleStartTime?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledTriggerProperties

        if (dataPullMode != other.dataPullMode) return false
        if (firstExecutionFrom != other.firstExecutionFrom) return false
        if (scheduleEndTime != other.scheduleEndTime) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleStartTime != other.scheduleStartTime) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.ScheduledTriggerProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
         */
        public var dataPullMode: aws.sdk.kotlin.services.customerprofiles.model.DataPullMode? = null
        /**
         * Specifies the date range for the records to import from the connector in the first flow run.
         */
        public var firstExecutionFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the scheduled end time for a scheduled-trigger flow.
         */
        public var scheduleEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The scheduling expression that determines the rate at which the schedule will run, for example rate (5 minutes).
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         */
        public var scheduleOffset: kotlin.Long? = null
        /**
         * Specifies the scheduled start time for a scheduled-trigger flow.
         */
        public var scheduleStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time zone used when referring to the date and time of a scheduled-triggered flow, such as America/New_York.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.ScheduledTriggerProperties) : this() {
            this.dataPullMode = x.dataPullMode
            this.firstExecutionFrom = x.firstExecutionFrom
            this.scheduleEndTime = x.scheduleEndTime
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.scheduleStartTime = x.scheduleStartTime
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.ScheduledTriggerProperties = ScheduledTriggerProperties(this)

        internal fun correctErrors(): Builder {
            if (scheduleExpression == null) scheduleExpression = ""
            return this
        }
    }
}
