// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutProfileObjectTypeRequest private constructor(builder: Builder) {
    /**
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
     */
    public val allowProfileCreation: kotlin.Boolean? = builder.allowProfileCreation
    /**
     * Description of the profile object type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The customer-provided key to encrypt the profile object that will be created in this profile object type.
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The number of days until the data in the object expires.
     */
    public val expirationDays: kotlin.Int? = builder.expirationDays
    /**
     * A map of the name and ObjectType field.
     */
    public val fields: Map<String, ObjectTypeField>? = builder.fields
    /**
     * A list of unique keys that can be used to map data to the profile.
     */
    public val keys: Map<String, List<ObjectTypeKey>>? = builder.keys
    /**
     * The amount of profile object max count assigned to the object type
     */
    public val maxProfileObjectCount: kotlin.Int? = builder.maxProfileObjectCount
    /**
     * The name of the profile object type.
     */
    public val objectTypeName: kotlin.String? = builder.objectTypeName
    /**
     * The format of your `sourceLastUpdatedTimestamp` that was previously set up.
     */
    public val sourceLastUpdatedTimestampFormat: kotlin.String? = builder.sourceLastUpdatedTimestampFormat
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A unique identifier for the object template. For some attributes in the request, the service will use the default value from the object template when TemplateId is present. If these attributes are present in the request, the service may return a `BadRequestException`. These attributes include: AllowProfileCreation, SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if AllowProfileCreation is set to true when TemplateId is set, the service may return a `BadRequestException`.
     */
    public val templateId: kotlin.String? = builder.templateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutProfileObjectTypeRequest(")
        append("allowProfileCreation=$allowProfileCreation,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainName=$domainName,")
        append("encryptionKey=$encryptionKey,")
        append("expirationDays=$expirationDays,")
        append("fields=*** Sensitive Data Redacted ***,")
        append("keys=*** Sensitive Data Redacted ***,")
        append("maxProfileObjectCount=$maxProfileObjectCount,")
        append("objectTypeName=$objectTypeName,")
        append("sourceLastUpdatedTimestampFormat=$sourceLastUpdatedTimestampFormat,")
        append("tags=$tags,")
        append("templateId=$templateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowProfileCreation?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (expirationDays ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (maxProfileObjectCount ?: 0)
        result = 31 * result + (objectTypeName?.hashCode() ?: 0)
        result = 31 * result + (sourceLastUpdatedTimestampFormat?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutProfileObjectTypeRequest

        if (allowProfileCreation != other.allowProfileCreation) return false
        if (description != other.description) return false
        if (domainName != other.domainName) return false
        if (encryptionKey != other.encryptionKey) return false
        if (expirationDays != other.expirationDays) return false
        if (fields != other.fields) return false
        if (keys != other.keys) return false
        if (maxProfileObjectCount != other.maxProfileObjectCount) return false
        if (objectTypeName != other.objectTypeName) return false
        if (sourceLastUpdatedTimestampFormat != other.sourceLastUpdatedTimestampFormat) return false
        if (tags != other.tags) return false
        if (templateId != other.templateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
         */
        public var allowProfileCreation: kotlin.Boolean? = null
        /**
         * Description of the profile object type.
         */
        public var description: kotlin.String? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The customer-provided key to encrypt the profile object that will be created in this profile object type.
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The number of days until the data in the object expires.
         */
        public var expirationDays: kotlin.Int? = null
        /**
         * A map of the name and ObjectType field.
         */
        public var fields: Map<String, ObjectTypeField>? = null
        /**
         * A list of unique keys that can be used to map data to the profile.
         */
        public var keys: Map<String, List<ObjectTypeKey>>? = null
        /**
         * The amount of profile object max count assigned to the object type
         */
        public var maxProfileObjectCount: kotlin.Int? = null
        /**
         * The name of the profile object type.
         */
        public var objectTypeName: kotlin.String? = null
        /**
         * The format of your `sourceLastUpdatedTimestamp` that was previously set up.
         */
        public var sourceLastUpdatedTimestampFormat: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * A unique identifier for the object template. For some attributes in the request, the service will use the default value from the object template when TemplateId is present. If these attributes are present in the request, the service may return a `BadRequestException`. These attributes include: AllowProfileCreation, SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if AllowProfileCreation is set to true when TemplateId is set, the service may return a `BadRequestException`.
         */
        public var templateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest) : this() {
            this.allowProfileCreation = x.allowProfileCreation
            this.description = x.description
            this.domainName = x.domainName
            this.encryptionKey = x.encryptionKey
            this.expirationDays = x.expirationDays
            this.fields = x.fields
            this.keys = x.keys
            this.maxProfileObjectCount = x.maxProfileObjectCount
            this.objectTypeName = x.objectTypeName
            this.sourceLastUpdatedTimestampFormat = x.sourceLastUpdatedTimestampFormat
            this.tags = x.tags
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = PutProfileObjectTypeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
