// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutIntegrationRequest private constructor(builder: Builder) {
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * A list of unique names for active event triggers associated with the integration.
     */
    public val eventTriggerNames: List<String>? = builder.eventTriggerNames
    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    public val flowDefinition: aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition? = builder.flowDefinition
    /**
     * The name of the profile object type.
     */
    public val objectTypeName: kotlin.String? = builder.objectTypeName
    /**
     * A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an `ObjectTypeName` (template) used to ingest the event. It supports the following event types: `SegmentIdentify`, `ShopifyCreateCustomers`, `ShopifyUpdateCustomers`, `ShopifyCreateDraftOrders`, `ShopifyUpdateDraftOrders`, `ShopifyCreateOrders`, and `ShopifyUpdatedOrders`.
     */
    public val objectTypeNames: Map<String, String>? = builder.objectTypeNames
    /**
     * The Amazon Resource Name (ARN) of the IAM role. The Integration uses this role to make Customer Profiles requests on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The URI of the S3 bucket or any other type of data source.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationRequest(")
        append("domainName=$domainName,")
        append("eventTriggerNames=$eventTriggerNames,")
        append("flowDefinition=*** Sensitive Data Redacted ***,")
        append("objectTypeName=$objectTypeName,")
        append("objectTypeNames=$objectTypeNames,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (eventTriggerNames?.hashCode() ?: 0)
        result = 31 * result + (flowDefinition?.hashCode() ?: 0)
        result = 31 * result + (objectTypeName?.hashCode() ?: 0)
        result = 31 * result + (objectTypeNames?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutIntegrationRequest

        if (domainName != other.domainName) return false
        if (eventTriggerNames != other.eventTriggerNames) return false
        if (flowDefinition != other.flowDefinition) return false
        if (objectTypeName != other.objectTypeName) return false
        if (objectTypeNames != other.objectTypeNames) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * A list of unique names for active event triggers associated with the integration.
         */
        public var eventTriggerNames: List<String>? = null
        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         */
        public var flowDefinition: aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition? = null
        /**
         * The name of the profile object type.
         */
        public var objectTypeName: kotlin.String? = null
        /**
         * A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an `ObjectTypeName` (template) used to ingest the event. It supports the following event types: `SegmentIdentify`, `ShopifyCreateCustomers`, `ShopifyUpdateCustomers`, `ShopifyCreateDraftOrders`, `ShopifyUpdateDraftOrders`, `ShopifyCreateOrders`, and `ShopifyUpdatedOrders`.
         */
        public var objectTypeNames: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role. The Integration uses this role to make Customer Profiles requests on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The URI of the S3 bucket or any other type of data source.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest) : this() {
            this.domainName = x.domainName
            this.eventTriggerNames = x.eventTriggerNames
            this.flowDefinition = x.flowDefinition
            this.objectTypeName = x.objectTypeName
            this.objectTypeNames = x.objectTypeNames
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest = PutIntegrationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition] inside the given [block]
         */
        public fun flowDefinition(block: aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition.Builder.() -> kotlin.Unit) {
            this.flowDefinition = aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
