// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object in a list that represents a domain.
 */
public class ListDomainItem private constructor(builder: Builder) {
    /**
     * The timestamp of when the domain was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The timestamp of when the domain was most recently edited.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.ListDomainItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDomainItem(")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDomainItem

        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.ListDomainItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp of when the domain was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The timestamp of when the domain was most recently edited.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.ListDomainItem) : this() {
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.ListDomainItem = ListDomainItem(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (domainName == null) domainName = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
