// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetUploadJobResponse private constructor(builder: Builder) {
    /**
     * The timestamp when the upload job was completed.
     */
    public val completedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.completedAt
    /**
     * The timestamp when the upload job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The expiry duration for the profiles ingested with the upload job.
     */
    public val dataExpiry: kotlin.Int? = builder.dataExpiry
    /**
     * The unique name of the upload job. Could be a file name to identify the upload job.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The mapping between CSV Columns and Profile Object attributes for the upload job.
     */
    public val fields: Map<String, ObjectTypeField>? = builder.fields
    /**
     * The unique identifier of the upload job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The summary of results for the upload job, including the number of updated, created, and failed records.
     */
    public val resultsSummary: aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary? = builder.resultsSummary
    /**
     * The status describing the status for the upload job. The following are Valid Values:
     * + **CREATED**: The upload job has been created, but has not started processing yet.
     * + **IN_PROGRESS**: The upload job is currently in progress, ingesting and processing the profile data.
     * + **PARTIALLY_SUCCEEDED**: The upload job has successfully completed the ingestion and processing of all profile data.
     * + **SUCCEEDED**: The upload job has successfully completed the ingestion and processing of all profile data.
     * + **FAILED**: The upload job has failed to complete.
     * + **STOPPED**: The upload job has been manually stopped or terminated before completion.
     */
    public val status: aws.sdk.kotlin.services.customerprofiles.model.UploadJobStatus? = builder.status
    /**
     * The reason for the current status of the upload job. Possible reasons:
     * + **VALIDATION_FAILURE**: The upload job has encountered an error or issue and was unable to complete the profile data ingestion.
     * + **INTERNAL_FAILURE**: Failure caused from service side
     */
    public val statusReason: aws.sdk.kotlin.services.customerprofiles.model.StatusReason? = builder.statusReason
    /**
     * The unique key columns used for de-duping the keys in the upload job.
     */
    public val uniqueKey: kotlin.String? = builder.uniqueKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetUploadJobResponse(")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("dataExpiry=$dataExpiry,")
        append("displayName=$displayName,")
        append("fields=*** Sensitive Data Redacted ***,")
        append("jobId=$jobId,")
        append("resultsSummary=$resultsSummary,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("uniqueKey=$uniqueKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedAt?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dataExpiry ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (resultsSummary?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (uniqueKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetUploadJobResponse

        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (dataExpiry != other.dataExpiry) return false
        if (displayName != other.displayName) return false
        if (fields != other.fields) return false
        if (jobId != other.jobId) return false
        if (resultsSummary != other.resultsSummary) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (uniqueKey != other.uniqueKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when the upload job was completed.
         */
        public var completedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when the upload job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The expiry duration for the profiles ingested with the upload job.
         */
        public var dataExpiry: kotlin.Int? = null
        /**
         * The unique name of the upload job. Could be a file name to identify the upload job.
         */
        public var displayName: kotlin.String? = null
        /**
         * The mapping between CSV Columns and Profile Object attributes for the upload job.
         */
        public var fields: Map<String, ObjectTypeField>? = null
        /**
         * The unique identifier of the upload job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The summary of results for the upload job, including the number of updated, created, and failed records.
         */
        public var resultsSummary: aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary? = null
        /**
         * The status describing the status for the upload job. The following are Valid Values:
         * + **CREATED**: The upload job has been created, but has not started processing yet.
         * + **IN_PROGRESS**: The upload job is currently in progress, ingesting and processing the profile data.
         * + **PARTIALLY_SUCCEEDED**: The upload job has successfully completed the ingestion and processing of all profile data.
         * + **SUCCEEDED**: The upload job has successfully completed the ingestion and processing of all profile data.
         * + **FAILED**: The upload job has failed to complete.
         * + **STOPPED**: The upload job has been manually stopped or terminated before completion.
         */
        public var status: aws.sdk.kotlin.services.customerprofiles.model.UploadJobStatus? = null
        /**
         * The reason for the current status of the upload job. Possible reasons:
         * + **VALIDATION_FAILURE**: The upload job has encountered an error or issue and was unable to complete the profile data ingestion.
         * + **INTERNAL_FAILURE**: Failure caused from service side
         */
        public var statusReason: aws.sdk.kotlin.services.customerprofiles.model.StatusReason? = null
        /**
         * The unique key columns used for de-duping the keys in the upload job.
         */
        public var uniqueKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse) : this() {
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.dataExpiry = x.dataExpiry
            this.displayName = x.displayName
            this.fields = x.fields
            this.jobId = x.jobId
            this.resultsSummary = x.resultsSummary
            this.status = x.status
            this.statusReason = x.statusReason
            this.uniqueKey = x.uniqueKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse = GetUploadJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary] inside the given [block]
         */
        public fun resultsSummary(block: aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary.Builder.() -> kotlin.Unit) {
            this.resultsSummary = aws.sdk.kotlin.services.customerprofiles.model.ResultsSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
