// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetSegmentSnapshotResponse private constructor(builder: Builder) {
    /**
     * The format in which the segment will be exported.
     */
    public val dataFormat: aws.sdk.kotlin.services.customerprofiles.model.DataFormat = requireNotNull(builder.dataFormat) { "A non-null value must be provided for dataFormat" }
    /**
     * The destination to which the segment will be exported. This field must be provided if the request is not submitted from the Amazon Connect Admin Website.
     */
    public val destinationUri: kotlin.String? = builder.destinationUri
    /**
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the role for conducting KMS and S3 operations.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The unique identifier of the segment snapshot.
     */
    public val snapshotId: kotlin.String = requireNotNull(builder.snapshotId) { "A non-null value must be provided for snapshotId" }
    /**
     * The status of the asynchronous job for exporting the segment snapshot.
     */
    public val status: aws.sdk.kotlin.services.customerprofiles.model.SegmentSnapshotStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The status message of the asynchronous job for exporting the segment snapshot.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSegmentSnapshotResponse(")
        append("dataFormat=$dataFormat,")
        append("destinationUri=$destinationUri,")
        append("encryptionKey=$encryptionKey,")
        append("roleArn=$roleArn,")
        append("snapshotId=$snapshotId,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataFormat.hashCode()
        result = 31 * result + (destinationUri?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotId.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSegmentSnapshotResponse

        if (dataFormat != other.dataFormat) return false
        if (destinationUri != other.destinationUri) return false
        if (encryptionKey != other.encryptionKey) return false
        if (roleArn != other.roleArn) return false
        if (snapshotId != other.snapshotId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The format in which the segment will be exported.
         */
        public var dataFormat: aws.sdk.kotlin.services.customerprofiles.model.DataFormat? = null
        /**
         * The destination to which the segment will be exported. This field must be provided if the request is not submitted from the Amazon Connect Admin Website.
         */
        public var destinationUri: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the role for conducting KMS and S3 operations.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The unique identifier of the segment snapshot.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The status of the asynchronous job for exporting the segment snapshot.
         */
        public var status: aws.sdk.kotlin.services.customerprofiles.model.SegmentSnapshotStatus? = null
        /**
         * The status message of the asynchronous job for exporting the segment snapshot.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotResponse) : this() {
            this.dataFormat = x.dataFormat
            this.destinationUri = x.destinationUri
            this.encryptionKey = x.encryptionKey
            this.roleArn = x.roleArn
            this.snapshotId = x.snapshotId
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotResponse = GetSegmentSnapshotResponse(this)

        internal fun correctErrors(): Builder {
            if (dataFormat == null) dataFormat = DataFormat.SdkUnknown("no value provided")
            if (snapshotId == null) snapshotId = ""
            if (status == null) status = SegmentSnapshotStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
