// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An instance of EventStream in a list of EventStreams.
 */
public class EventStreamSummary private constructor(builder: Builder) {
    /**
     * Summary information about the Kinesis data stream.
     */
    public val destinationSummary: aws.sdk.kotlin.services.customerprofiles.model.DestinationSummary? = builder.destinationSummary
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * A unique identifier for the event stream.
     */
    public val eventStreamArn: kotlin.String = requireNotNull(builder.eventStreamArn) { "A non-null value must be provided for eventStreamArn" }
    /**
     * The name of the event stream.
     */
    public val eventStreamName: kotlin.String = requireNotNull(builder.eventStreamName) { "A non-null value must be provided for eventStreamName" }
    /**
     * The operational state of destination stream for export.
     */
    public val state: aws.sdk.kotlin.services.customerprofiles.model.EventStreamState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The timestamp when the `State` changed to `STOPPED`.
     */
    public val stoppedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.stoppedSince
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.EventStreamSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventStreamSummary(")
        append("destinationSummary=$destinationSummary,")
        append("domainName=$domainName,")
        append("eventStreamArn=$eventStreamArn,")
        append("eventStreamName=$eventStreamName,")
        append("state=$state,")
        append("stoppedSince=$stoppedSince,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationSummary?.hashCode() ?: 0
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (eventStreamArn.hashCode())
        result = 31 * result + (eventStreamName.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (stoppedSince?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventStreamSummary

        if (destinationSummary != other.destinationSummary) return false
        if (domainName != other.domainName) return false
        if (eventStreamArn != other.eventStreamArn) return false
        if (eventStreamName != other.eventStreamName) return false
        if (state != other.state) return false
        if (stoppedSince != other.stoppedSince) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.EventStreamSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Summary information about the Kinesis data stream.
         */
        public var destinationSummary: aws.sdk.kotlin.services.customerprofiles.model.DestinationSummary? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * A unique identifier for the event stream.
         */
        public var eventStreamArn: kotlin.String? = null
        /**
         * The name of the event stream.
         */
        public var eventStreamName: kotlin.String? = null
        /**
         * The operational state of destination stream for export.
         */
        public var state: aws.sdk.kotlin.services.customerprofiles.model.EventStreamState? = null
        /**
         * The timestamp when the `State` changed to `STOPPED`.
         */
        public var stoppedSince: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.EventStreamSummary) : this() {
            this.destinationSummary = x.destinationSummary
            this.domainName = x.domainName
            this.eventStreamArn = x.eventStreamArn
            this.eventStreamName = x.eventStreamName
            this.state = x.state
            this.stoppedSince = x.stoppedSince
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.EventStreamSummary = EventStreamSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.DestinationSummary] inside the given [block]
         */
        public fun destinationSummary(block: aws.sdk.kotlin.services.customerprofiles.model.DestinationSummary.Builder.() -> kotlin.Unit) {
            this.destinationSummary = aws.sdk.kotlin.services.customerprofiles.model.DestinationSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainName == null) domainName = ""
            if (eventStreamArn == null) eventStreamArn = ""
            if (eventStreamName == null) eventStreamName = ""
            if (state == null) state = EventStreamState.SdkUnknown("no value provided")
            return this
        }
    }
}
