// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDomainRequest private constructor(builder: Builder) {
    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
     */
    public val deadLetterQueueUrl: kotlin.String? = builder.deadLetterQueueUrl
    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    public val defaultEncryptionKey: kotlin.String? = builder.defaultEncryptionKey
    /**
     * The default number of days until the data within the domain expires.
     */
    public val defaultExpirationDays: kotlin.Int? = builder.defaultExpirationDays
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     */
    public val matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest? = builder.matching
    /**
     * The process of matching duplicate profiles using the Rule-Based matching. If `RuleBasedMatching` = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the `RuleBasedMatchingRequest`. You can use the `ListRuleBasedMatches` and `GetSimilarProfiles` API to return and review the results. Also, if you have configured `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download the results from S3.
     */
    public val ruleBasedMatching: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest? = builder.ruleBasedMatching
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainRequest(")
        append("deadLetterQueueUrl=$deadLetterQueueUrl,")
        append("defaultEncryptionKey=$defaultEncryptionKey,")
        append("defaultExpirationDays=$defaultExpirationDays,")
        append("domainName=$domainName,")
        append("matching=$matching,")
        append("ruleBasedMatching=$ruleBasedMatching,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deadLetterQueueUrl?.hashCode() ?: 0
        result = 31 * result + (defaultEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (defaultExpirationDays ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (matching?.hashCode() ?: 0)
        result = 31 * result + (ruleBasedMatching?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainRequest

        if (deadLetterQueueUrl != other.deadLetterQueueUrl) return false
        if (defaultEncryptionKey != other.defaultEncryptionKey) return false
        if (defaultExpirationDays != other.defaultExpirationDays) return false
        if (domainName != other.domainName) return false
        if (matching != other.matching) return false
        if (ruleBasedMatching != other.ruleBasedMatching) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
         */
        public var deadLetterQueueUrl: kotlin.String? = null
        /**
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         */
        public var defaultEncryptionKey: kotlin.String? = null
        /**
         * The default number of days until the data within the domain expires.
         */
        public var defaultExpirationDays: kotlin.Int? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
         *
         * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
         */
        public var matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest? = null
        /**
         * The process of matching duplicate profiles using the Rule-Based matching. If `RuleBasedMatching` = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the `RuleBasedMatchingRequest`. You can use the `ListRuleBasedMatches` and `GetSimilarProfiles` API to return and review the results. Also, if you have configured `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download the results from S3.
         */
        public var ruleBasedMatching: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.CreateDomainRequest) : this() {
            this.deadLetterQueueUrl = x.deadLetterQueueUrl
            this.defaultEncryptionKey = x.defaultEncryptionKey
            this.defaultExpirationDays = x.defaultExpirationDays
            this.domainName = x.domainName
            this.matching = x.matching
            this.ruleBasedMatching = x.ruleBasedMatching
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainRequest = CreateDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest] inside the given [block]
         */
        public fun matching(block: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest.Builder.() -> kotlin.Unit) {
            this.matching = aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest] inside the given [block]
         */
        public fun ruleBasedMatching(block: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest.Builder.() -> kotlin.Unit) {
            this.ruleBasedMatching = aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
