// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information about the `AttributeTypesSelector `where the rule-based identity resolution uses to match profiles. You can choose how profiles are compared across attribute types and which attribute to use for matching from each type. There are three attribute types you can configure:
 * + Email type
 *    + You can choose from `Email`, `BusinessEmail`, and `PersonalEmail`
 * + Phone number type
 *    + You can choose from `Phone`, `HomePhone`, and `MobilePhone`
 * + Address type
 *    + You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`
 *
 * You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `AttributeMatchingModel`. When choosing `MANY_TO_MANY`, the system can match attribute across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A and the value of `BusinessEmail` field of Profile B matches, the two profiles are matched on the Email type. When choosing `ONE_TO_ONE` the system can only match if the sub-types are exact matches. For example, only when the value of the `Email` field of Profile A and the value of the `Email` field of Profile B matches, the two profiles are matched on the Email type.
 */
public class AttributeTypesSelector private constructor(builder: Builder) {
    /**
     * The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
     *
     * You only can use the Address type in the `MatchingRule`. For example, if you want to match profile based on `BusinessAddress.City` or `MaillingAddress.City`, you need to choose the `BusinessAddress` and the `MaillingAddress` to represent the Address type and specify the `Address.City` on the matching rule.
     */
    public val address: List<String>? = builder.address
    /**
     * Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
     */
    public val attributeMatchingModel: aws.sdk.kotlin.services.customerprofiles.model.AttributeMatchingModel = requireNotNull(builder.attributeMatchingModel) { "A non-null value must be provided for attributeMatchingModel" }
    /**
     * The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
     *
     * You only can use the `EmailAddress` type in the `MatchingRule`. For example, if you want to match profile based on `PersonalEmailAddress` or `BusinessEmailAddress`, you need to choose the `PersonalEmailAddress` and the `BusinessEmailAddress` to represent the `EmailAddress` type and only specify the `EmailAddress` on the matching rule.
     */
    public val emailAddress: List<String>? = builder.emailAddress
    /**
     * The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
     *
     * You only can use the `PhoneNumber` type in the `MatchingRule`. For example, if you want to match a profile based on `Phone` or `HomePhone`, you need to choose the `Phone` and the `HomePhone` to represent the `PhoneNumber` type and only specify the `PhoneNumber` on the matching rule.
     */
    public val phoneNumber: List<String>? = builder.phoneNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeTypesSelector(")
        append("address=$address,")
        append("attributeMatchingModel=$attributeMatchingModel,")
        append("emailAddress=$emailAddress,")
        append("phoneNumber=$phoneNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (attributeMatchingModel.hashCode())
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeTypesSelector

        if (address != other.address) return false
        if (attributeMatchingModel != other.attributeMatchingModel) return false
        if (emailAddress != other.emailAddress) return false
        if (phoneNumber != other.phoneNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
         *
         * You only can use the Address type in the `MatchingRule`. For example, if you want to match profile based on `BusinessAddress.City` or `MaillingAddress.City`, you need to choose the `BusinessAddress` and the `MaillingAddress` to represent the Address type and specify the `Address.City` on the matching rule.
         */
        public var address: List<String>? = null
        /**
         * Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
         */
        public var attributeMatchingModel: aws.sdk.kotlin.services.customerprofiles.model.AttributeMatchingModel? = null
        /**
         * The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
         *
         * You only can use the `EmailAddress` type in the `MatchingRule`. For example, if you want to match profile based on `PersonalEmailAddress` or `BusinessEmailAddress`, you need to choose the `PersonalEmailAddress` and the `BusinessEmailAddress` to represent the `EmailAddress` type and only specify the `EmailAddress` on the matching rule.
         */
        public var emailAddress: List<String>? = null
        /**
         * The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
         *
         * You only can use the `PhoneNumber` type in the `MatchingRule`. For example, if you want to match a profile based on `Phone` or `HomePhone`, you need to choose the `Phone` and the `HomePhone` to represent the `PhoneNumber` type and only specify the `PhoneNumber` on the matching rule.
         */
        public var phoneNumber: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector) : this() {
            this.address = x.address
            this.attributeMatchingModel = x.attributeMatchingModel
            this.emailAddress = x.emailAddress
            this.phoneNumber = x.phoneNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector = AttributeTypesSelector(this)

        internal fun correctErrors(): Builder {
            if (attributeMatchingModel == null) attributeMatchingModel = AttributeMatchingModel.SdkUnknown("no value provided")
            return this
        }
    }
}
