// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Workflow step details for `APPFLOW_INTEGRATION` workflow.
 */
public class AppflowIntegrationWorkflowStep private constructor(builder: Builder) {
    /**
     * End datetime of records pulled in batch during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val batchRecordsEndTime: kotlin.String = requireNotNull(builder.batchRecordsEndTime) { "A non-null value must be provided for batchRecordsEndTime" }
    /**
     * Start datetime of records pulled in batch during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val batchRecordsStartTime: kotlin.String = requireNotNull(builder.batchRecordsStartTime) { "A non-null value must be provided for batchRecordsStartTime" }
    /**
     * Creation timestamp of workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Message indicating execution of workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val executionMessage: kotlin.String = requireNotNull(builder.executionMessage) { "A non-null value must be provided for executionMessage" }
    /**
     * Name of the flow created during execution of workflow step. `APPFLOW_INTEGRATION` workflow type creates an appflow flow during workflow step execution on the customers behalf.
     */
    public val flowName: kotlin.String = requireNotNull(builder.flowName) { "A non-null value must be provided for flowName" }
    /**
     * Last updated timestamp for workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * Total number of records processed during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
     */
    public val recordsProcessed: kotlin.Long = builder.recordsProcessed
    /**
     * Workflow step status for `APPFLOW_INTEGRATION` workflow.
     */
    public val status: aws.sdk.kotlin.services.customerprofiles.model.Status = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.AppflowIntegrationWorkflowStep = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppflowIntegrationWorkflowStep(")
        append("batchRecordsEndTime=$batchRecordsEndTime,")
        append("batchRecordsStartTime=$batchRecordsStartTime,")
        append("createdAt=$createdAt,")
        append("executionMessage=$executionMessage,")
        append("flowName=$flowName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("recordsProcessed=$recordsProcessed,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchRecordsEndTime.hashCode()
        result = 31 * result + (batchRecordsStartTime.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (executionMessage.hashCode())
        result = 31 * result + (flowName.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (recordsProcessed.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppflowIntegrationWorkflowStep

        if (batchRecordsEndTime != other.batchRecordsEndTime) return false
        if (batchRecordsStartTime != other.batchRecordsStartTime) return false
        if (createdAt != other.createdAt) return false
        if (executionMessage != other.executionMessage) return false
        if (flowName != other.flowName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (recordsProcessed != other.recordsProcessed) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.AppflowIntegrationWorkflowStep = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * End datetime of records pulled in batch during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var batchRecordsEndTime: kotlin.String? = null
        /**
         * Start datetime of records pulled in batch during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var batchRecordsStartTime: kotlin.String? = null
        /**
         * Creation timestamp of workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Message indicating execution of workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var executionMessage: kotlin.String? = null
        /**
         * Name of the flow created during execution of workflow step. `APPFLOW_INTEGRATION` workflow type creates an appflow flow during workflow step execution on the customers behalf.
         */
        public var flowName: kotlin.String? = null
        /**
         * Last updated timestamp for workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Total number of records processed during execution of workflow step for `APPFLOW_INTEGRATION` workflow.
         */
        public var recordsProcessed: kotlin.Long = 0L
        /**
         * Workflow step status for `APPFLOW_INTEGRATION` workflow.
         */
        public var status: aws.sdk.kotlin.services.customerprofiles.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.AppflowIntegrationWorkflowStep) : this() {
            this.batchRecordsEndTime = x.batchRecordsEndTime
            this.batchRecordsStartTime = x.batchRecordsStartTime
            this.createdAt = x.createdAt
            this.executionMessage = x.executionMessage
            this.flowName = x.flowName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.recordsProcessed = x.recordsProcessed
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.AppflowIntegrationWorkflowStep = AppflowIntegrationWorkflowStep(this)

        internal fun correctErrors(): Builder {
            if (batchRecordsEndTime == null) batchRecordsEndTime = ""
            if (batchRecordsStartTime == null) batchRecordsStartTime = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (executionMessage == null) executionMessage = ""
            if (flowName == null) flowName = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (status == null) status = Status.SdkUnknown("no value provided")
            return this
        }
    }
}
