// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.customerprofiles.auth.CustomerProfilesAuthSchemeProvider
import aws.sdk.kotlin.services.customerprofiles.auth.DefaultCustomerProfilesAuthSchemeProvider
import aws.sdk.kotlin.services.customerprofiles.endpoints.CustomerProfilesEndpointParameters
import aws.sdk.kotlin.services.customerprofiles.endpoints.CustomerProfilesEndpointProvider
import aws.sdk.kotlin.services.customerprofiles.endpoints.DefaultCustomerProfilesEndpointProvider
import aws.sdk.kotlin.services.customerprofiles.model.AddProfileKeyRequest
import aws.sdk.kotlin.services.customerprofiles.model.AddProfileKeyResponse
import aws.sdk.kotlin.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.BatchGetCalculatedAttributeForProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.BatchGetProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.BatchGetProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateCalculatedAttributeDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateCalculatedAttributeDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateDomainLayoutRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateDomainLayoutResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateDomainRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateEventStreamRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateEventStreamResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateEventTriggerRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateEventTriggerResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateIntegrationWorkflowRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateIntegrationWorkflowResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentEstimateRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentEstimateResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentSnapshotRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateSegmentSnapshotResponse
import aws.sdk.kotlin.services.customerprofiles.model.CreateUploadJobRequest
import aws.sdk.kotlin.services.customerprofiles.model.CreateUploadJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteDomainLayoutRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteDomainLayoutResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteDomainRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteEventStreamRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteEventStreamResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteEventTriggerRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteEventTriggerResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteIntegrationRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteIntegrationResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileKeyRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileKeyResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileObjectRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileObjectResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileObjectTypeRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileObjectTypeResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteSegmentDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteSegmentDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.customerprofiles.model.DeleteWorkflowResponse
import aws.sdk.kotlin.services.customerprofiles.model.DetectProfileObjectTypeRequest
import aws.sdk.kotlin.services.customerprofiles.model.DetectProfileObjectTypeResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetAutoMergingPreviewRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetAutoMergingPreviewResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetCalculatedAttributeDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetCalculatedAttributeDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetCalculatedAttributeForProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetCalculatedAttributeForProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetDomainLayoutRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetDomainLayoutResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetDomainRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetEventStreamRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetEventStreamResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetEventTriggerRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetEventTriggerResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetIdentityResolutionJobRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetIdentityResolutionJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetIntegrationResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetMatchesRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetMatchesResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeTemplateRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeTemplateResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentEstimateRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentEstimateResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentMembershipRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentMembershipResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSegmentSnapshotResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetSimilarProfilesRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetSimilarProfilesResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobPathRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobPathResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetUploadJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetWorkflowRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetWorkflowResponse
import aws.sdk.kotlin.services.customerprofiles.model.GetWorkflowStepsRequest
import aws.sdk.kotlin.services.customerprofiles.model.GetWorkflowStepsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListAccountIntegrationsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListAccountIntegrationsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListCalculatedAttributeDefinitionsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListCalculatedAttributeDefinitionsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListCalculatedAttributesForProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListCalculatedAttributesForProfileResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainLayoutsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainLayoutsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListDomainsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListEventStreamsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListEventStreamsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListEventTriggersRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListEventTriggersResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListIdentityResolutionJobsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListIdentityResolutionJobsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListIntegrationsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListIntegrationsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListObjectTypeAttributesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListObjectTypeAttributesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileAttributeValuesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileAttributeValuesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectTypeTemplatesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectTypeTemplatesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectTypesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectTypesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListRuleBasedMatchesRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListRuleBasedMatchesResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListSegmentDefinitionsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListSegmentDefinitionsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListUploadJobsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListUploadJobsResponse
import aws.sdk.kotlin.services.customerprofiles.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.customerprofiles.model.MergeProfilesRequest
import aws.sdk.kotlin.services.customerprofiles.model.MergeProfilesResponse
import aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationRequest
import aws.sdk.kotlin.services.customerprofiles.model.PutIntegrationResponse
import aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectRequest
import aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectResponse
import aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest
import aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeResponse
import aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest
import aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesResponse
import aws.sdk.kotlin.services.customerprofiles.model.StartUploadJobRequest
import aws.sdk.kotlin.services.customerprofiles.model.StartUploadJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.StopUploadJobRequest
import aws.sdk.kotlin.services.customerprofiles.model.StopUploadJobResponse
import aws.sdk.kotlin.services.customerprofiles.model.TagResourceRequest
import aws.sdk.kotlin.services.customerprofiles.model.TagResourceResponse
import aws.sdk.kotlin.services.customerprofiles.model.UntagResourceRequest
import aws.sdk.kotlin.services.customerprofiles.model.UntagResourceResponse
import aws.sdk.kotlin.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionResponse
import aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainLayoutRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainLayoutResponse
import aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.UpdateEventTriggerRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateEventTriggerResponse
import aws.sdk.kotlin.services.customerprofiles.model.UpdateProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateProfileResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Customer Profiles"
public const val SdkVersion: String = "1.5.34"
public const val ServiceApiVersion: String = "2020-08-15"

/**
 * # Amazon Connect Customer Profiles
 * + [Customer Profiles actions](https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Connect_Customer_Profiles.html)
 * + [Customer Profiles data types](https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Connect_Customer_Profiles.html)
 *
 * Amazon Connect Customer Profiles is a unified customer profile for your contact center that has pre-built connectors powered by AppFlow that make it easy to combine customer information from third party applications, such as Salesforce (CRM), ServiceNow (ITSM), and your enterprise resource planning (ERP), with contact history from your Amazon Connect contact center.
 *
 * For more information about the Amazon Connect Customer Profiles feature, see [Use Customer Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/customer-profiles.html) in the *Amazon Connect Administrator's Guide*.
 */
public interface CustomerProfilesClient : SdkClient {
    /**
     * CustomerProfilesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CustomerProfilesClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CustomerProfiles",
                "CUSTOMER_PROFILES",
                "customer_profiles",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CustomerProfilesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CustomerProfilesClient = DefaultCustomerProfilesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CustomerProfilesEndpointProvider = builder.endpointProvider ?: DefaultCustomerProfilesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CustomerProfilesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCustomerProfilesAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Customer Profiles"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CustomerProfilesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CustomerProfilesAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a new key value with a specific profile, such as a Contact Record ContactId.
     *
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.
     */
    public suspend fun addProfileKey(input: AddProfileKeyRequest): AddProfileKeyResponse

    /**
     * Fetch the possible attribute values given the attribute name.
     */
    public suspend fun batchGetCalculatedAttributeForProfile(input: BatchGetCalculatedAttributeForProfileRequest): BatchGetCalculatedAttributeForProfileResponse

    /**
     * Get a batch of profiles.
     */
    public suspend fun batchGetProfile(input: BatchGetProfileRequest): BatchGetProfileResponse

    /**
     * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles will be included in the calculated attribute, which can be retrieved for a profile using the [GetCalculatedAttributeForProfile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html) API. Defining a calculated attribute makes it available for all profiles within a domain. Each calculated attribute can only reference one `ObjectType` and at most, two fields from that `ObjectType`.
     */
    public suspend fun createCalculatedAttributeDefinition(input: CreateCalculatedAttributeDefinitionRequest): CreateCalculatedAttributeDefinitionResponse

    /**
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.
     *
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
     *
     * Use this API or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     *
     * It is not possible to associate a Customer Profiles domain with an Amazon Connect Instance directly from the API. If you would like to create a domain and associate a Customer Profiles domain, use the Amazon Connect admin website. For more information, see [Enable Customer Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/enable-customer-profiles.html#enable-customer-profiles-step1).
     *
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
     */
    public suspend fun createDomainLayout(input: CreateDomainLayoutRequest): CreateDomainLayoutResponse

    /**
     * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and updated through Amazon Connect Customer Profiles.
     *
     * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon Web Services account as the customer profiles domain
     */
    public suspend fun createEventStream(input: CreateEventStreamRequest): CreateEventStreamResponse

    /**
     * Creates an event trigger, which specifies the rules when to perform action based on customer's ingested data.
     *
     * Each event stream can be associated with only one integration in the same region and AWS account as the event stream.
     */
    public suspend fun createEventTrigger(input: CreateEventTriggerRequest): CreateEventTriggerResponse

    /**
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
     */
    public suspend fun createIntegrationWorkflow(input: CreateIntegrationWorkflowRequest): CreateIntegrationWorkflowResponse

    /**
     * Creates a standard profile.
     *
     * A standard profile represents the following attributes for a customer profile in a domain.
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Creates a segment definition associated to the given domain.
     */
    public suspend fun createSegmentDefinition(input: CreateSegmentDefinitionRequest): CreateSegmentDefinitionResponse

    /**
     * Creates a segment estimate query.
     */
    public suspend fun createSegmentEstimate(input: CreateSegmentEstimateRequest): CreateSegmentEstimateResponse

    /**
     * Triggers a job to export a segment to a specified destination.
     */
    public suspend fun createSegmentSnapshot(input: CreateSegmentSnapshotRequest): CreateSegmentSnapshotResponse

    /**
     * Creates an Upload job to ingest data for segment imports. The metadata is created for the job with the provided field mapping and unique key.
     */
    public suspend fun createUploadJob(input: CreateUploadJobRequest): CreateUploadJobResponse

    /**
     * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own using the CreateCalculatedAttributeDefinition API if you want it back.
     */
    public suspend fun deleteCalculatedAttributeDefinition(input: DeleteCalculatedAttributeDefinitionRequest): DeleteCalculatedAttributeDefinitionResponse

    /**
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
     */
    public suspend fun deleteDomainLayout(input: DeleteDomainLayoutRequest): DeleteDomainLayoutResponse

    /**
     * Disables and deletes the specified event stream.
     */
    public suspend fun deleteEventStream(input: DeleteEventStreamRequest): DeleteEventStreamResponse

    /**
     * Disable and deletes the Event Trigger.
     *
     * You cannot delete an Event Trigger with an active Integration associated.
     */
    public suspend fun deleteEventTrigger(input: DeleteEventTriggerRequest): DeleteEventTriggerResponse

    /**
     * Removes an integration from a specific domain.
     */
    public suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse

    /**
     * Deletes the standard customer profile and all data pertaining to the profile.
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Removes a searchable key from a customer profile.
     */
    public suspend fun deleteProfileKey(input: DeleteProfileKeyRequest): DeleteProfileKeyResponse

    /**
     * Removes an object associated with a profile of a given ProfileObjectType.
     */
    public suspend fun deleteProfileObject(input: DeleteProfileObjectRequest): DeleteProfileObjectResponse

    /**
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.
     */
    public suspend fun deleteProfileObjectType(input: DeleteProfileObjectTypeRequest): DeleteProfileObjectTypeResponse

    /**
     * Deletes a segment definition from the domain.
     */
    public suspend fun deleteSegmentDefinition(input: DeleteSegmentDefinitionRequest): DeleteSegmentDefinitionResponse

    /**
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     */
    public suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * The process of detecting profile object type mapping by using given objects.
     */
    public suspend fun detectProfileObjectType(input: DetectProfileObjectTypeRequest): DetectProfileObjectTypeResponse

    /**
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.
     *
     * You can't view which profiles are matched and would be merged.
     *
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity Resolution Job. Include **at least** two matching attributes. If your matching list includes too few attributes (such as only `FirstName` or only `LastName`), there may be a large number of matches. This increases the chances of erroneous merges.
     */
    public suspend fun getAutoMergingPreview(input: GetAutoMergingPreviewRequest): GetAutoMergingPreviewResponse

    /**
     * Provides more information on a calculated attribute definition for Customer Profiles.
     */
    public suspend fun getCalculatedAttributeDefinition(input: GetCalculatedAttributeDefinitionRequest): GetCalculatedAttributeDefinitionResponse

    /**
     * Retrieve a calculated attribute for a customer profile.
     */
    public suspend fun getCalculatedAttributeForProfile(input: GetCalculatedAttributeForProfileRequest): GetCalculatedAttributeForProfileResponse

    /**
     * Returns information about a specific domain.
     */
    public suspend fun getDomain(input: GetDomainRequest): GetDomainResponse

    /**
     * Gets the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
     */
    public suspend fun getDomainLayout(input: GetDomainLayoutRequest): GetDomainLayoutResponse

    /**
     * Returns information about the specified event stream in a specific domain.
     */
    public suspend fun getEventStream(input: GetEventStreamRequest): GetEventStreamResponse

    /**
     * Get a specific Event Trigger from the domain.
     */
    public suspend fun getEventTrigger(input: GetEventTriggerRequest): GetEventTriggerResponse

    /**
     * Returns information about an Identity Resolution Job in a specific domain.
     *
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see [Use Identity Resolution to consolidate similar profiles](https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html).
     */
    public suspend fun getIdentityResolutionJob(input: GetIdentityResolutionJobRequest): GetIdentityResolutionJobResponse

    /**
     * Returns an integration for a domain.
     */
    public suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse

    /**
     * Before calling this API, use [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable identity resolution: set `Matching` to true.
     *
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning process.
     *
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     *
     * Amazon Connect uses the following profile attributes to identify matches:
     * + PhoneNumber
     * + HomePhoneNumber
     * + BusinessPhoneNumber
     * + MobilePhoneNumber
     * + EmailAddress
     * + PersonalEmailAddress
     * + BusinessEmailAddress
     * + FullName
     *
     * For example, two or more profiles—with spelling mistakes such as **John Doe** and **Jhn Doe**, or different casing email addresses such as **JOHN_DOE@ANYCOMPANY.COM** and **johndoe@anycompany.com**, or different phone number formats such as **555-010-0000** and **+1-555-010-0000**—can be detected as belonging to the same customer **John Doe** and merged into a unified profile.
     */
    public suspend fun getMatches(input: GetMatchesRequest): GetMatchesResponse

    /**
     * Returns the object types for a specific domain.
     */
    public suspend fun getProfileObjectType(input: GetProfileObjectTypeRequest): GetProfileObjectTypeResponse

    /**
     * Returns the template information for a specific object type.
     *
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the template.
     */
    public suspend fun getProfileObjectTypeTemplate(input: GetProfileObjectTypeTemplateRequest): GetProfileObjectTypeTemplateResponse

    /**
     * Gets a segment definition from the domain.
     */
    public suspend fun getSegmentDefinition(input: GetSegmentDefinitionRequest): GetSegmentDefinitionResponse

    /**
     * Gets the result of a segment estimate query.
     */
    public suspend fun getSegmentEstimate(input: GetSegmentEstimateRequest): GetSegmentEstimateResponse

    /**
     * Determines if the given profiles are within a segment.
     */
    public suspend fun getSegmentMembership(input: GetSegmentMembershipRequest): GetSegmentMembershipResponse

    /**
     * Retrieve the latest status of a segment snapshot.
     */
    public suspend fun getSegmentSnapshot(input: GetSegmentSnapshotRequest): GetSegmentSnapshotResponse

    /**
     * Returns a set of profiles that belong to the same matching group using the `matchId` or `profileId`. You can also specify the type of matching that you want for finding similar profiles using either `RULE_BASED_MATCHING` or `ML_BASED_MATCHING`.
     */
    public suspend fun getSimilarProfiles(input: GetSimilarProfilesRequest): GetSimilarProfilesResponse

    /**
     * This API retrieves the details of a specific upload job.
     */
    public suspend fun getUploadJob(input: GetUploadJobRequest): GetUploadJobResponse

    /**
     * This API retrieves the pre-signed URL and client token for uploading the file associated with the upload job.
     */
    public suspend fun getUploadJobPath(input: GetUploadJobPathRequest): GetUploadJobPathResponse

    /**
     * Get details of specified workflow.
     */
    public suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Get granular list of steps in workflow.
     */
    public suspend fun getWorkflowSteps(input: GetWorkflowStepsRequest): GetWorkflowStepsResponse

    /**
     * Lists all of the integrations associated to a specific URI in the AWS account.
     */
    public suspend fun listAccountIntegrations(input: ListAccountIntegrationsRequest): ListAccountIntegrationsResponse

    /**
     * Lists calculated attribute definitions for Customer Profiles
     */
    public suspend fun listCalculatedAttributeDefinitions(input: ListCalculatedAttributeDefinitionsRequest): ListCalculatedAttributeDefinitionsResponse

    /**
     * Retrieve a list of calculated attributes for a customer profile.
     */
    public suspend fun listCalculatedAttributesForProfile(input: ListCalculatedAttributesForProfileRequest): ListCalculatedAttributesForProfileResponse

    /**
     * Lists the existing layouts that can be used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
     */
    public suspend fun listDomainLayouts(input: ListDomainLayoutsRequest): ListDomainLayoutsResponse

    /**
     * Returns a list of all the domains for an AWS account that have been created.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest { }): ListDomainsResponse

    /**
     * Returns a list of all the event streams in a specific domain.
     */
    public suspend fun listEventStreams(input: ListEventStreamsRequest): ListEventStreamsResponse

    /**
     * List all Event Triggers under a domain.
     */
    public suspend fun listEventTriggers(input: ListEventTriggersRequest): ListEventTriggersResponse

    /**
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by `JobStartTime`.
     */
    public suspend fun listIdentityResolutionJobs(input: ListIdentityResolutionJobsRequest): ListIdentityResolutionJobsResponse

    /**
     * Lists all of the integrations in your domain.
     */
    public suspend fun listIntegrations(input: ListIntegrationsRequest): ListIntegrationsResponse

    /**
     * Fetch the possible attribute values given the attribute name.
     */
    public suspend fun listObjectTypeAttributes(input: ListObjectTypeAttributesRequest): ListObjectTypeAttributesResponse

    /**
     * Fetch the possible attribute values given the attribute name.
     */
    public suspend fun listProfileAttributeValues(input: ListProfileAttributeValuesRequest): ListProfileAttributeValuesResponse

    /**
     * Lists all of the template information for object types.
     */
    public suspend fun listProfileObjectTypeTemplates(input: ListProfileObjectTypeTemplatesRequest = ListProfileObjectTypeTemplatesRequest { }): ListProfileObjectTypeTemplatesResponse

    /**
     * Lists all of the templates available within the service.
     */
    public suspend fun listProfileObjectTypes(input: ListProfileObjectTypesRequest): ListProfileObjectTypesResponse

    /**
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     */
    public suspend fun listProfileObjects(input: ListProfileObjectsRequest): ListProfileObjectsResponse

    /**
     * Returns a set of `MatchIds` that belong to the given domain.
     */
    public suspend fun listRuleBasedMatches(input: ListRuleBasedMatchesRequest): ListRuleBasedMatchesResponse

    /**
     * Lists all segment definitions under a domain.
     */
    public suspend fun listSegmentDefinitions(input: ListSegmentDefinitionsRequest): ListSegmentDefinitionsResponse

    /**
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * This API retrieves a list of upload jobs for the specified domain.
     */
    public suspend fun listUploadJobs(input: ListUploadJobsRequest): ListUploadJobsResponse

    /**
     * Query to list all workflows.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse

    /**
     * Runs an AWS Lambda job that does the following:
     * + All the profileKeys in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the objects in the `ProfileToBeMerged` will be moved to the main profile.
     * + All the `ProfileToBeMerged` will be deleted at the end.
     * + All the profileKeys in the `ProfileIdsToBeMerged` will be moved to the main profile.
     * + Standard fields are merged as follows:
     *    + Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     *    + When there are conflicting fields:
     *       + If no `SourceProfileIds` entry is specified, the main Profile value is always taken.
     *       + If a `SourceProfileIds` entry is specified, the specified profileId is always taken, even if it is a NULL value.
     *
     * You can use MergeProfiles together with [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html), which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).
     */
    public suspend fun mergeProfiles(input: MergeProfilesRequest): MergeProfilesResponse

    /**
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.
     *
     * An integration can belong to only one domain.
     *
     * To add or remove tags on an existing Integration, see [ TagResource ](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[ UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
     */
    public suspend fun putIntegration(input: PutIntegrationRequest): PutIntegrationResponse

    /**
     * Adds additional objects to customer profiles of a given ObjectType.
     *
     * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred profile.
     *
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition.
     *
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     */
    public suspend fun putProfileObject(input: PutProfileObjectRequest): PutProfileObjectResponse

    /**
     * Defines a ProfileObjectType.
     *
     * To add or remove tags on an existing ObjectType, see [ TagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
     */
    public suspend fun putProfileObjectType(input: PutProfileObjectTypeRequest): PutProfileObjectTypeResponse

    /**
     * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone, _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a `KeyName` and `Values` list.
     *
     * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s) pairs using either `AND` or `OR` logic.
     */
    public suspend fun searchProfiles(input: SearchProfilesRequest): SearchProfilesResponse

    /**
     * This API starts the processing of an upload job to ingest profile data.
     */
    public suspend fun startUploadJob(input: StartUploadJobRequest): StartUploadJobResponse

    /**
     * This API stops the processing of an upload job.
     */
    public suspend fun stopUploadJob(input: StopUploadJobRequest): StopUploadJobResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     *
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     *
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date range of a calculated attribute will not trigger inclusion of historical data greater than the current date range.
     */
    public suspend fun updateCalculatedAttributeDefinition(input: UpdateCalculatedAttributeDefinitionRequest): UpdateCalculatedAttributeDefinitionResponse

    /**
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     *
     * After a domain is created, the name can’t be changed.
     *
     * Use this API or [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
     *
     * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
     *
     * To add or remove tags on an existing Domain, see [TagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
     */
    public suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse

    /**
     * Updates the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
     */
    public suspend fun updateDomainLayout(input: UpdateDomainLayoutRequest): UpdateDomainLayoutResponse

    /**
     * Update the properties of an Event Trigger.
     */
    public suspend fun updateEventTrigger(input: UpdateEventTriggerRequest): UpdateEventTriggerResponse

    /**
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     *
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CustomerProfilesClient.withConfig(block: CustomerProfilesClient.Config.Builder.() -> Unit): CustomerProfilesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCustomerProfilesClient(newConfig)
}

/**
 * Associates a new key value with a specific profile, such as a Contact Record ContactId.
 *
 * A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.
 */
public suspend inline fun CustomerProfilesClient.addProfileKey(crossinline block: AddProfileKeyRequest.Builder.() -> Unit): AddProfileKeyResponse = addProfileKey(AddProfileKeyRequest.Builder().apply(block).build())

/**
 * Fetch the possible attribute values given the attribute name.
 */
public suspend inline fun CustomerProfilesClient.batchGetCalculatedAttributeForProfile(crossinline block: BatchGetCalculatedAttributeForProfileRequest.Builder.() -> Unit): BatchGetCalculatedAttributeForProfileResponse = batchGetCalculatedAttributeForProfile(BatchGetCalculatedAttributeForProfileRequest.Builder().apply(block).build())

/**
 * Get a batch of profiles.
 */
public suspend inline fun CustomerProfilesClient.batchGetProfile(crossinline block: BatchGetProfileRequest.Builder.() -> Unit): BatchGetProfileResponse = batchGetProfile(BatchGetProfileRequest.Builder().apply(block).build())

/**
 * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles will be included in the calculated attribute, which can be retrieved for a profile using the [GetCalculatedAttributeForProfile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html) API. Defining a calculated attribute makes it available for all profiles within a domain. Each calculated attribute can only reference one `ObjectType` and at most, two fields from that `ObjectType`.
 */
public suspend inline fun CustomerProfilesClient.createCalculatedAttributeDefinition(crossinline block: CreateCalculatedAttributeDefinitionRequest.Builder.() -> Unit): CreateCalculatedAttributeDefinitionResponse = createCalculatedAttributeDefinition(CreateCalculatedAttributeDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.
 *
 * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
 *
 * Use this API or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
 *
 * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
 *
 * It is not possible to associate a Customer Profiles domain with an Amazon Connect Instance directly from the API. If you would like to create a domain and associate a Customer Profiles domain, use the Amazon Connect admin website. For more information, see [Enable Customer Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/enable-customer-profiles.html#enable-customer-profiles-step1).
 *
 * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.
 */
public suspend inline fun CustomerProfilesClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Creates the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
 */
public suspend inline fun CustomerProfilesClient.createDomainLayout(crossinline block: CreateDomainLayoutRequest.Builder.() -> Unit): CreateDomainLayoutResponse = createDomainLayout(CreateDomainLayoutRequest.Builder().apply(block).build())

/**
 * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and updated through Amazon Connect Customer Profiles.
 *
 * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon Web Services account as the customer profiles domain
 */
public suspend inline fun CustomerProfilesClient.createEventStream(crossinline block: CreateEventStreamRequest.Builder.() -> Unit): CreateEventStreamResponse = createEventStream(CreateEventStreamRequest.Builder().apply(block).build())

/**
 * Creates an event trigger, which specifies the rules when to perform action based on customer's ingested data.
 *
 * Each event stream can be associated with only one integration in the same region and AWS account as the event stream.
 */
public suspend inline fun CustomerProfilesClient.createEventTrigger(crossinline block: CreateEventTriggerRequest.Builder.() -> Unit): CreateEventTriggerResponse = createEventTrigger(CreateEventTriggerRequest.Builder().apply(block).build())

/**
 * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
 */
public suspend inline fun CustomerProfilesClient.createIntegrationWorkflow(crossinline block: CreateIntegrationWorkflowRequest.Builder.() -> Unit): CreateIntegrationWorkflowResponse = createIntegrationWorkflow(CreateIntegrationWorkflowRequest.Builder().apply(block).build())

/**
 * Creates a standard profile.
 *
 * A standard profile represents the following attributes for a customer profile in a domain.
 */
public suspend inline fun CustomerProfilesClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Creates a segment definition associated to the given domain.
 */
public suspend inline fun CustomerProfilesClient.createSegmentDefinition(crossinline block: CreateSegmentDefinitionRequest.Builder.() -> Unit): CreateSegmentDefinitionResponse = createSegmentDefinition(CreateSegmentDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a segment estimate query.
 */
public suspend inline fun CustomerProfilesClient.createSegmentEstimate(crossinline block: CreateSegmentEstimateRequest.Builder.() -> Unit): CreateSegmentEstimateResponse = createSegmentEstimate(CreateSegmentEstimateRequest.Builder().apply(block).build())

/**
 * Triggers a job to export a segment to a specified destination.
 */
public suspend inline fun CustomerProfilesClient.createSegmentSnapshot(crossinline block: CreateSegmentSnapshotRequest.Builder.() -> Unit): CreateSegmentSnapshotResponse = createSegmentSnapshot(CreateSegmentSnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Upload job to ingest data for segment imports. The metadata is created for the job with the provided field mapping and unique key.
 */
public suspend inline fun CustomerProfilesClient.createUploadJob(crossinline block: CreateUploadJobRequest.Builder.() -> Unit): CreateUploadJobResponse = createUploadJob(CreateUploadJobRequest.Builder().apply(block).build())

/**
 * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own using the CreateCalculatedAttributeDefinition API if you want it back.
 */
public suspend inline fun CustomerProfilesClient.deleteCalculatedAttributeDefinition(crossinline block: DeleteCalculatedAttributeDefinitionRequest.Builder.() -> Unit): DeleteCalculatedAttributeDefinitionResponse = deleteCalculatedAttributeDefinition(DeleteCalculatedAttributeDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.
 */
public suspend inline fun CustomerProfilesClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
 */
public suspend inline fun CustomerProfilesClient.deleteDomainLayout(crossinline block: DeleteDomainLayoutRequest.Builder.() -> Unit): DeleteDomainLayoutResponse = deleteDomainLayout(DeleteDomainLayoutRequest.Builder().apply(block).build())

/**
 * Disables and deletes the specified event stream.
 */
public suspend inline fun CustomerProfilesClient.deleteEventStream(crossinline block: DeleteEventStreamRequest.Builder.() -> Unit): DeleteEventStreamResponse = deleteEventStream(DeleteEventStreamRequest.Builder().apply(block).build())

/**
 * Disable and deletes the Event Trigger.
 *
 * You cannot delete an Event Trigger with an active Integration associated.
 */
public suspend inline fun CustomerProfilesClient.deleteEventTrigger(crossinline block: DeleteEventTriggerRequest.Builder.() -> Unit): DeleteEventTriggerResponse = deleteEventTrigger(DeleteEventTriggerRequest.Builder().apply(block).build())

/**
 * Removes an integration from a specific domain.
 */
public suspend inline fun CustomerProfilesClient.deleteIntegration(crossinline block: DeleteIntegrationRequest.Builder.() -> Unit): DeleteIntegrationResponse = deleteIntegration(DeleteIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes the standard customer profile and all data pertaining to the profile.
 */
public suspend inline fun CustomerProfilesClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Removes a searchable key from a customer profile.
 */
public suspend inline fun CustomerProfilesClient.deleteProfileKey(crossinline block: DeleteProfileKeyRequest.Builder.() -> Unit): DeleteProfileKeyResponse = deleteProfileKey(DeleteProfileKeyRequest.Builder().apply(block).build())

/**
 * Removes an object associated with a profile of a given ProfileObjectType.
 */
public suspend inline fun CustomerProfilesClient.deleteProfileObject(crossinline block: DeleteProfileObjectRequest.Builder.() -> Unit): DeleteProfileObjectResponse = deleteProfileObject(DeleteProfileObjectRequest.Builder().apply(block).build())

/**
 * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.
 */
public suspend inline fun CustomerProfilesClient.deleteProfileObjectType(crossinline block: DeleteProfileObjectTypeRequest.Builder.() -> Unit): DeleteProfileObjectTypeResponse = deleteProfileObjectType(DeleteProfileObjectTypeRequest.Builder().apply(block).build())

/**
 * Deletes a segment definition from the domain.
 */
public suspend inline fun CustomerProfilesClient.deleteSegmentDefinition(crossinline block: DeleteSegmentDefinitionRequest.Builder.() -> Unit): DeleteSegmentDefinitionResponse = deleteSegmentDefinition(DeleteSegmentDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes the specified workflow and all its corresponding resources. This is an async process.
 */
public suspend inline fun CustomerProfilesClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit): DeleteWorkflowResponse = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * The process of detecting profile object type mapping by using given objects.
 */
public suspend inline fun CustomerProfilesClient.detectProfileObjectType(crossinline block: DetectProfileObjectTypeRequest.Builder.() -> Unit): DetectProfileObjectTypeResponse = detectProfileObjectType(DetectProfileObjectTypeRequest.Builder().apply(block).build())

/**
 * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.
 *
 * You can't view which profiles are matched and would be merged.
 *
 * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity Resolution Job. Include **at least** two matching attributes. If your matching list includes too few attributes (such as only `FirstName` or only `LastName`), there may be a large number of matches. This increases the chances of erroneous merges.
 */
public suspend inline fun CustomerProfilesClient.getAutoMergingPreview(crossinline block: GetAutoMergingPreviewRequest.Builder.() -> Unit): GetAutoMergingPreviewResponse = getAutoMergingPreview(GetAutoMergingPreviewRequest.Builder().apply(block).build())

/**
 * Provides more information on a calculated attribute definition for Customer Profiles.
 */
public suspend inline fun CustomerProfilesClient.getCalculatedAttributeDefinition(crossinline block: GetCalculatedAttributeDefinitionRequest.Builder.() -> Unit): GetCalculatedAttributeDefinitionResponse = getCalculatedAttributeDefinition(GetCalculatedAttributeDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieve a calculated attribute for a customer profile.
 */
public suspend inline fun CustomerProfilesClient.getCalculatedAttributeForProfile(crossinline block: GetCalculatedAttributeForProfileRequest.Builder.() -> Unit): GetCalculatedAttributeForProfileResponse = getCalculatedAttributeForProfile(GetCalculatedAttributeForProfileRequest.Builder().apply(block).build())

/**
 * Returns information about a specific domain.
 */
public suspend inline fun CustomerProfilesClient.getDomain(crossinline block: GetDomainRequest.Builder.() -> Unit): GetDomainResponse = getDomain(GetDomainRequest.Builder().apply(block).build())

/**
 * Gets the layout to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
 */
public suspend inline fun CustomerProfilesClient.getDomainLayout(crossinline block: GetDomainLayoutRequest.Builder.() -> Unit): GetDomainLayoutResponse = getDomainLayout(GetDomainLayoutRequest.Builder().apply(block).build())

/**
 * Returns information about the specified event stream in a specific domain.
 */
public suspend inline fun CustomerProfilesClient.getEventStream(crossinline block: GetEventStreamRequest.Builder.() -> Unit): GetEventStreamResponse = getEventStream(GetEventStreamRequest.Builder().apply(block).build())

/**
 * Get a specific Event Trigger from the domain.
 */
public suspend inline fun CustomerProfilesClient.getEventTrigger(crossinline block: GetEventTriggerRequest.Builder.() -> Unit): GetEventTriggerResponse = getEventTrigger(GetEventTriggerRequest.Builder().apply(block).build())

/**
 * Returns information about an Identity Resolution Job in a specific domain.
 *
 * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see [Use Identity Resolution to consolidate similar profiles](https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html).
 */
public suspend inline fun CustomerProfilesClient.getIdentityResolutionJob(crossinline block: GetIdentityResolutionJobRequest.Builder.() -> Unit): GetIdentityResolutionJobResponse = getIdentityResolutionJob(GetIdentityResolutionJobRequest.Builder().apply(block).build())

/**
 * Returns an integration for a domain.
 */
public suspend inline fun CustomerProfilesClient.getIntegration(crossinline block: GetIntegrationRequest.Builder.() -> Unit): GetIntegrationResponse = getIntegration(GetIntegrationRequest.Builder().apply(block).build())

/**
 * Before calling this API, use [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) or [UpdateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html) to enable identity resolution: set `Matching` to true.
 *
 * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning process.
 *
 * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
 *
 * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
 *
 * Amazon Connect uses the following profile attributes to identify matches:
 * + PhoneNumber
 * + HomePhoneNumber
 * + BusinessPhoneNumber
 * + MobilePhoneNumber
 * + EmailAddress
 * + PersonalEmailAddress
 * + BusinessEmailAddress
 * + FullName
 *
 * For example, two or more profiles—with spelling mistakes such as **John Doe** and **Jhn Doe**, or different casing email addresses such as **JOHN_DOE@ANYCOMPANY.COM** and **johndoe@anycompany.com**, or different phone number formats such as **555-010-0000** and **+1-555-010-0000**—can be detected as belonging to the same customer **John Doe** and merged into a unified profile.
 */
public suspend inline fun CustomerProfilesClient.getMatches(crossinline block: GetMatchesRequest.Builder.() -> Unit): GetMatchesResponse = getMatches(GetMatchesRequest.Builder().apply(block).build())

/**
 * Returns the object types for a specific domain.
 */
public suspend inline fun CustomerProfilesClient.getProfileObjectType(crossinline block: GetProfileObjectTypeRequest.Builder.() -> Unit): GetProfileObjectTypeResponse = getProfileObjectType(GetProfileObjectTypeRequest.Builder().apply(block).build())

/**
 * Returns the template information for a specific object type.
 *
 * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the template.
 */
public suspend inline fun CustomerProfilesClient.getProfileObjectTypeTemplate(crossinline block: GetProfileObjectTypeTemplateRequest.Builder.() -> Unit): GetProfileObjectTypeTemplateResponse = getProfileObjectTypeTemplate(GetProfileObjectTypeTemplateRequest.Builder().apply(block).build())

/**
 * Gets a segment definition from the domain.
 */
public suspend inline fun CustomerProfilesClient.getSegmentDefinition(crossinline block: GetSegmentDefinitionRequest.Builder.() -> Unit): GetSegmentDefinitionResponse = getSegmentDefinition(GetSegmentDefinitionRequest.Builder().apply(block).build())

/**
 * Gets the result of a segment estimate query.
 */
public suspend inline fun CustomerProfilesClient.getSegmentEstimate(crossinline block: GetSegmentEstimateRequest.Builder.() -> Unit): GetSegmentEstimateResponse = getSegmentEstimate(GetSegmentEstimateRequest.Builder().apply(block).build())

/**
 * Determines if the given profiles are within a segment.
 */
public suspend inline fun CustomerProfilesClient.getSegmentMembership(crossinline block: GetSegmentMembershipRequest.Builder.() -> Unit): GetSegmentMembershipResponse = getSegmentMembership(GetSegmentMembershipRequest.Builder().apply(block).build())

/**
 * Retrieve the latest status of a segment snapshot.
 */
public suspend inline fun CustomerProfilesClient.getSegmentSnapshot(crossinline block: GetSegmentSnapshotRequest.Builder.() -> Unit): GetSegmentSnapshotResponse = getSegmentSnapshot(GetSegmentSnapshotRequest.Builder().apply(block).build())

/**
 * Returns a set of profiles that belong to the same matching group using the `matchId` or `profileId`. You can also specify the type of matching that you want for finding similar profiles using either `RULE_BASED_MATCHING` or `ML_BASED_MATCHING`.
 */
public suspend inline fun CustomerProfilesClient.getSimilarProfiles(crossinline block: GetSimilarProfilesRequest.Builder.() -> Unit): GetSimilarProfilesResponse = getSimilarProfiles(GetSimilarProfilesRequest.Builder().apply(block).build())

/**
 * This API retrieves the details of a specific upload job.
 */
public suspend inline fun CustomerProfilesClient.getUploadJob(crossinline block: GetUploadJobRequest.Builder.() -> Unit): GetUploadJobResponse = getUploadJob(GetUploadJobRequest.Builder().apply(block).build())

/**
 * This API retrieves the pre-signed URL and client token for uploading the file associated with the upload job.
 */
public suspend inline fun CustomerProfilesClient.getUploadJobPath(crossinline block: GetUploadJobPathRequest.Builder.() -> Unit): GetUploadJobPathResponse = getUploadJobPath(GetUploadJobPathRequest.Builder().apply(block).build())

/**
 * Get details of specified workflow.
 */
public suspend inline fun CustomerProfilesClient.getWorkflow(crossinline block: GetWorkflowRequest.Builder.() -> Unit): GetWorkflowResponse = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

/**
 * Get granular list of steps in workflow.
 */
public suspend inline fun CustomerProfilesClient.getWorkflowSteps(crossinline block: GetWorkflowStepsRequest.Builder.() -> Unit): GetWorkflowStepsResponse = getWorkflowSteps(GetWorkflowStepsRequest.Builder().apply(block).build())

/**
 * Lists all of the integrations associated to a specific URI in the AWS account.
 */
public suspend inline fun CustomerProfilesClient.listAccountIntegrations(crossinline block: ListAccountIntegrationsRequest.Builder.() -> Unit): ListAccountIntegrationsResponse = listAccountIntegrations(ListAccountIntegrationsRequest.Builder().apply(block).build())

/**
 * Lists calculated attribute definitions for Customer Profiles
 */
public suspend inline fun CustomerProfilesClient.listCalculatedAttributeDefinitions(crossinline block: ListCalculatedAttributeDefinitionsRequest.Builder.() -> Unit): ListCalculatedAttributeDefinitionsResponse = listCalculatedAttributeDefinitions(ListCalculatedAttributeDefinitionsRequest.Builder().apply(block).build())

/**
 * Retrieve a list of calculated attributes for a customer profile.
 */
public suspend inline fun CustomerProfilesClient.listCalculatedAttributesForProfile(crossinline block: ListCalculatedAttributesForProfileRequest.Builder.() -> Unit): ListCalculatedAttributesForProfileResponse = listCalculatedAttributesForProfile(ListCalculatedAttributesForProfileRequest.Builder().apply(block).build())

/**
 * Lists the existing layouts that can be used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
 */
public suspend inline fun CustomerProfilesClient.listDomainLayouts(crossinline block: ListDomainLayoutsRequest.Builder.() -> Unit): ListDomainLayoutsResponse = listDomainLayouts(ListDomainLayoutsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the domains for an AWS account that have been created.
 */
public suspend inline fun CustomerProfilesClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the event streams in a specific domain.
 */
public suspend inline fun CustomerProfilesClient.listEventStreams(crossinline block: ListEventStreamsRequest.Builder.() -> Unit): ListEventStreamsResponse = listEventStreams(ListEventStreamsRequest.Builder().apply(block).build())

/**
 * List all Event Triggers under a domain.
 */
public suspend inline fun CustomerProfilesClient.listEventTriggers(crossinline block: ListEventTriggersRequest.Builder.() -> Unit): ListEventTriggersResponse = listEventTriggers(ListEventTriggersRequest.Builder().apply(block).build())

/**
 * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by `JobStartTime`.
 */
public suspend inline fun CustomerProfilesClient.listIdentityResolutionJobs(crossinline block: ListIdentityResolutionJobsRequest.Builder.() -> Unit): ListIdentityResolutionJobsResponse = listIdentityResolutionJobs(ListIdentityResolutionJobsRequest.Builder().apply(block).build())

/**
 * Lists all of the integrations in your domain.
 */
public suspend inline fun CustomerProfilesClient.listIntegrations(crossinline block: ListIntegrationsRequest.Builder.() -> Unit): ListIntegrationsResponse = listIntegrations(ListIntegrationsRequest.Builder().apply(block).build())

/**
 * Fetch the possible attribute values given the attribute name.
 */
public suspend inline fun CustomerProfilesClient.listObjectTypeAttributes(crossinline block: ListObjectTypeAttributesRequest.Builder.() -> Unit): ListObjectTypeAttributesResponse = listObjectTypeAttributes(ListObjectTypeAttributesRequest.Builder().apply(block).build())

/**
 * Fetch the possible attribute values given the attribute name.
 */
public suspend inline fun CustomerProfilesClient.listProfileAttributeValues(crossinline block: ListProfileAttributeValuesRequest.Builder.() -> Unit): ListProfileAttributeValuesResponse = listProfileAttributeValues(ListProfileAttributeValuesRequest.Builder().apply(block).build())

/**
 * Lists all of the template information for object types.
 */
public suspend inline fun CustomerProfilesClient.listProfileObjectTypeTemplates(crossinline block: ListProfileObjectTypeTemplatesRequest.Builder.() -> Unit): ListProfileObjectTypeTemplatesResponse = listProfileObjectTypeTemplates(ListProfileObjectTypeTemplatesRequest.Builder().apply(block).build())

/**
 * Lists all of the templates available within the service.
 */
public suspend inline fun CustomerProfilesClient.listProfileObjectTypes(crossinline block: ListProfileObjectTypesRequest.Builder.() -> Unit): ListProfileObjectTypesResponse = listProfileObjectTypes(ListProfileObjectTypesRequest.Builder().apply(block).build())

/**
 * Returns a list of objects associated with a profile of a given ProfileObjectType.
 */
public suspend inline fun CustomerProfilesClient.listProfileObjects(crossinline block: ListProfileObjectsRequest.Builder.() -> Unit): ListProfileObjectsResponse = listProfileObjects(ListProfileObjectsRequest.Builder().apply(block).build())

/**
 * Returns a set of `MatchIds` that belong to the given domain.
 */
public suspend inline fun CustomerProfilesClient.listRuleBasedMatches(crossinline block: ListRuleBasedMatchesRequest.Builder.() -> Unit): ListRuleBasedMatchesResponse = listRuleBasedMatches(ListRuleBasedMatchesRequest.Builder().apply(block).build())

/**
 * Lists all segment definitions under a domain.
 */
public suspend inline fun CustomerProfilesClient.listSegmentDefinitions(crossinline block: ListSegmentDefinitionsRequest.Builder.() -> Unit): ListSegmentDefinitionsResponse = listSegmentDefinitions(ListSegmentDefinitionsRequest.Builder().apply(block).build())

/**
 * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
 */
public suspend inline fun CustomerProfilesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This API retrieves a list of upload jobs for the specified domain.
 */
public suspend inline fun CustomerProfilesClient.listUploadJobs(crossinline block: ListUploadJobsRequest.Builder.() -> Unit): ListUploadJobsResponse = listUploadJobs(ListUploadJobsRequest.Builder().apply(block).build())

/**
 * Query to list all workflows.
 */
public suspend inline fun CustomerProfilesClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Runs an AWS Lambda job that does the following:
 * + All the profileKeys in the `ProfileToBeMerged` will be moved to the main profile.
 * + All the objects in the `ProfileToBeMerged` will be moved to the main profile.
 * + All the `ProfileToBeMerged` will be deleted at the end.
 * + All the profileKeys in the `ProfileIdsToBeMerged` will be moved to the main profile.
 * + Standard fields are merged as follows:
 *    + Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
 *    + When there are conflicting fields:
 *       + If no `SourceProfileIds` entry is specified, the main Profile value is always taken.
 *       + If a `SourceProfileIds` entry is specified, the specified profileId is always taken, even if it is a NULL value.
 *
 * You can use MergeProfiles together with [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html), which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).
 */
public suspend inline fun CustomerProfilesClient.mergeProfiles(crossinline block: MergeProfilesRequest.Builder.() -> Unit): MergeProfilesResponse = mergeProfiles(MergeProfilesRequest.Builder().apply(block).build())

/**
 * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.
 *
 * An integration can belong to only one domain.
 *
 * To add or remove tags on an existing Integration, see [ TagResource ](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[ UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
 */
public suspend inline fun CustomerProfilesClient.putIntegration(crossinline block: PutIntegrationRequest.Builder.() -> Unit): PutIntegrationResponse = putIntegration(PutIntegrationRequest.Builder().apply(block).build())

/**
 * Adds additional objects to customer profiles of a given ObjectType.
 *
 * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred profile.
 *
 * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition.
 *
 * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
 */
public suspend inline fun CustomerProfilesClient.putProfileObject(crossinline block: PutProfileObjectRequest.Builder.() -> Unit): PutProfileObjectResponse = putProfileObject(PutProfileObjectRequest.Builder().apply(block).build())

/**
 * Defines a ProfileObjectType.
 *
 * To add or remove tags on an existing ObjectType, see [ TagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
 */
public suspend inline fun CustomerProfilesClient.putProfileObjectType(crossinline block: PutProfileObjectTypeRequest.Builder.() -> Unit): PutProfileObjectTypeResponse = putProfileObjectType(PutProfileObjectTypeRequest.Builder().apply(block).build())

/**
 * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone, _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a `KeyName` and `Values` list.
 *
 * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s) pairs using either `AND` or `OR` logic.
 */
public suspend inline fun CustomerProfilesClient.searchProfiles(crossinline block: SearchProfilesRequest.Builder.() -> Unit): SearchProfilesResponse = searchProfiles(SearchProfilesRequest.Builder().apply(block).build())

/**
 * This API starts the processing of an upload job to ingest profile data.
 */
public suspend inline fun CustomerProfilesClient.startUploadJob(crossinline block: StartUploadJobRequest.Builder.() -> Unit): StartUploadJobResponse = startUploadJob(StartUploadJobRequest.Builder().apply(block).build())

/**
 * This API stops the processing of an upload job.
 */
public suspend inline fun CustomerProfilesClient.stopUploadJob(crossinline block: StopUploadJobRequest.Builder.() -> Unit): StopUploadJobResponse = stopUploadJob(StopUploadJobRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
 *
 * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
 *
 * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource.
 */
public suspend inline fun CustomerProfilesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.
 */
public suspend inline fun CustomerProfilesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date range of a calculated attribute will not trigger inclusion of historical data greater than the current date range.
 */
public suspend inline fun CustomerProfilesClient.updateCalculatedAttributeDefinition(crossinline block: UpdateCalculatedAttributeDefinitionRequest.Builder.() -> Unit): UpdateCalculatedAttributeDefinitionResponse = updateCalculatedAttributeDefinition(UpdateCalculatedAttributeDefinitionRequest.Builder().apply(block).build())

/**
 * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
 *
 * After a domain is created, the name can’t be changed.
 *
 * Use this API or [CreateDomain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) to enable [identity resolution](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html): set `Matching` to true.
 *
 * To prevent cross-service impersonation when you call this API, see [Cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html) for sample policies that you should apply.
 *
 * To add or remove tags on an existing Domain, see [TagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html)/[UntagResource](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html).
 */
public suspend inline fun CustomerProfilesClient.updateDomain(crossinline block: UpdateDomainRequest.Builder.() -> Unit): UpdateDomainResponse = updateDomain(UpdateDomainRequest.Builder().apply(block).build())

/**
 * Updates the layout used to view data for a specific domain. This API can only be invoked from the Amazon Connect admin website.
 */
public suspend inline fun CustomerProfilesClient.updateDomainLayout(crossinline block: UpdateDomainLayoutRequest.Builder.() -> Unit): UpdateDomainLayoutResponse = updateDomainLayout(UpdateDomainLayoutRequest.Builder().apply(block).build())

/**
 * Update the properties of an Event Trigger.
 */
public suspend inline fun CustomerProfilesClient.updateEventTrigger(crossinline block: UpdateEventTriggerRequest.Builder.() -> Unit): UpdateEventTriggerResponse = updateEventTrigger(UpdateEventTriggerRequest.Builder().apply(block).build())

/**
 * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
 *
 * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.
 */
public suspend inline fun CustomerProfilesClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())
