// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.FieldSourceProfileIds
import aws.sdk.kotlin.services.customerprofiles.model.MergeProfilesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class MergeProfilesOperationSerializer: HttpSerialize<MergeProfilesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: MergeProfilesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainName}"))
                add(PercentEncoding.Path.encode("profiles"))
                add(PercentEncoding.Path.encode("objects"))
                add(PercentEncoding.Path.encode("merge"))
            }
        }

        val payload = serializeMergeProfilesOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeMergeProfilesOperationBody(context: ExecutionContext, input: MergeProfilesRequest): ByteArray {
    val serializer = JsonSerializer()
    val FIELDSOURCEPROFILEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FieldSourceProfileIds"))
    val MAINPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MainProfileId"))
    val PROFILEIDSTOBEMERGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProfileIdsToBeMerged"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIELDSOURCEPROFILEIDS_DESCRIPTOR)
        field(MAINPROFILEID_DESCRIPTOR)
        field(PROFILEIDSTOBEMERGED_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.fieldSourceProfileIds?.let { field(FIELDSOURCEPROFILEIDS_DESCRIPTOR, it, ::serializeFieldSourceProfileIdsDocument) }
        input.mainProfileId?.let { field(MAINPROFILEID_DESCRIPTOR, it) }
        if (input.profileIdsToBeMerged != null) {
            listField(PROFILEIDSTOBEMERGED_DESCRIPTOR) {
                for (el0 in input.profileIdsToBeMerged) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
