// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.customerprofiles.model.Status
import aws.sdk.kotlin.services.customerprofiles.model.WorkflowType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListWorkflowsOperationSerializer: HttpSerialize<ListWorkflowsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListWorkflowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainName}"))
                add(PercentEncoding.Path.encode("workflows"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.maxResults != null) add("max-results", "${input.maxResults}")
                if (input.nextToken != null) add("next-token", input.nextToken)
            }
        }

        val payload = serializeListWorkflowsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListWorkflowsOperationBody(context: ExecutionContext, input: ListWorkflowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val QUERYENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("QueryEndDate"))
    val QUERYSTARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("QueryStartDate"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val WORKFLOWTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("WorkflowType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUERYENDDATE_DESCRIPTOR)
        field(QUERYSTARTDATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WORKFLOWTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.queryEndDate?.let { field(QUERYENDDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.queryStartDate?.let { field(QUERYSTARTDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        input.workflowType?.let { field(WORKFLOWTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
