// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetMatchesResponse
import aws.sdk.kotlin.services.customerprofiles.model.MatchItem
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetMatchesOperationDeserializer: HttpDeserialize<GetMatchesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMatchesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMatchesError(context, call)
        }
        val builder = GetMatchesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMatchesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMatchesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMatchesOperationBody(builder: GetMatchesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MATCHGENERATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("MatchGenerationDate"))
    val MATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Matches"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val POTENTIALMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PotentialMatches"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MATCHGENERATIONDATE_DESCRIPTOR)
        field(MATCHES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(POTENTIALMATCHES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MATCHGENERATIONDATE_DESCRIPTOR.index -> builder.matchGenerationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                MATCHES_DESCRIPTOR.index -> builder.matches =
                    deserializer.deserializeList(MATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<MatchItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMatchItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                POTENTIALMATCHES_DESCRIPTOR.index -> builder.potentialMatches = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
