// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.DomainStats
import aws.sdk.kotlin.services.customerprofiles.model.GetDomainResponse
import aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse
import aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetDomainOperationDeserializer: HttpDeserialize<GetDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDomainError(context, call)
        }
        val builder = GetDomainResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDomainOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDomainError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDomainOperationBody(builder: GetDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DEADLETTERQUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeadLetterQueueUrl"))
    val DEFAULTENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultEncryptionKey"))
    val DEFAULTEXPIRATIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DefaultExpirationDays"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val MATCHING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Matching"))
    val RULEBASEDMATCHING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleBasedMatching"))
    val STATS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Stats"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DEADLETTERQUEUEURL_DESCRIPTOR)
        field(DEFAULTENCRYPTIONKEY_DESCRIPTOR)
        field(DEFAULTEXPIRATIONDAYS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(MATCHING_DESCRIPTOR)
        field(RULEBASEDMATCHING_DESCRIPTOR)
        field(STATS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEADLETTERQUEUEURL_DESCRIPTOR.index -> builder.deadLetterQueueUrl = deserializeString()
                DEFAULTENCRYPTIONKEY_DESCRIPTOR.index -> builder.defaultEncryptionKey = deserializeString()
                DEFAULTEXPIRATIONDAYS_DESCRIPTOR.index -> builder.defaultExpirationDays = deserializeInt()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                MATCHING_DESCRIPTOR.index -> builder.matching = deserializeMatchingResponseDocument(deserializer)
                RULEBASEDMATCHING_DESCRIPTOR.index -> builder.ruleBasedMatching = deserializeRuleBasedMatchingResponseDocument(deserializer)
                STATS_DESCRIPTOR.index -> builder.stats = deserializeDomainStatsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
