// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetAutoMergingPreviewResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAutoMergingPreviewOperationDeserializer: HttpDeserialize<GetAutoMergingPreviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAutoMergingPreviewResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAutoMergingPreviewError(context, call)
        }
        val builder = GetAutoMergingPreviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAutoMergingPreviewOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAutoMergingPreviewError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAutoMergingPreviewOperationBody(builder: GetAutoMergingPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val NUMBEROFMATCHESINSAMPLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfMatchesInSample"))
    val NUMBEROFPROFILESINSAMPLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfProfilesInSample"))
    val NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfProfilesWillBeMerged"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINNAME_DESCRIPTOR)
        field(NUMBEROFMATCHESINSAMPLE_DESCRIPTOR)
        field(NUMBEROFPROFILESINSAMPLE_DESCRIPTOR)
        field(NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                NUMBEROFMATCHESINSAMPLE_DESCRIPTOR.index -> builder.numberOfMatchesInSample = deserializeLong()
                NUMBEROFPROFILESINSAMPLE_DESCRIPTOR.index -> builder.numberOfProfilesInSample = deserializeLong()
                NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR.index -> builder.numberOfProfilesWillBeMerged = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
