// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.Address
import aws.sdk.kotlin.services.customerprofiles.model.CreateProfileRequest
import aws.sdk.kotlin.services.customerprofiles.model.Gender
import aws.sdk.kotlin.services.customerprofiles.model.PartyType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateProfileOperationSerializer: HttpSerialize<CreateProfileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainName}"))
                add(PercentEncoding.Path.encode("profiles"))
            }
        }

        val payload = serializeCreateProfileOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateProfileOperationBody(context: ExecutionContext, input: CreateProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCOUNTNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountNumber"))
    val ADDITIONALINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdditionalInformation"))
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Address"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val BILLINGADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BillingAddress"))
    val BIRTHDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BirthDate"))
    val BUSINESSEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BusinessEmailAddress"))
    val BUSINESSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BusinessName"))
    val BUSINESSPHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BusinessPhoneNumber"))
    val EMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EmailAddress"))
    val FIRSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirstName"))
    val GENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Gender"))
    val GENDERSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GenderString"))
    val HOMEPHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HomePhoneNumber"))
    val LASTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastName"))
    val MAILINGADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MailingAddress"))
    val MIDDLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MiddleName"))
    val MOBILEPHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MobilePhoneNumber"))
    val PARTYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PartyType"))
    val PARTYTYPESTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PartyTypeString"))
    val PERSONALEMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PersonalEmailAddress"))
    val PHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PhoneNumber"))
    val SHIPPINGADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ShippingAddress"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTNUMBER_DESCRIPTOR)
        field(ADDITIONALINFORMATION_DESCRIPTOR)
        field(ADDRESS_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(BILLINGADDRESS_DESCRIPTOR)
        field(BIRTHDATE_DESCRIPTOR)
        field(BUSINESSEMAILADDRESS_DESCRIPTOR)
        field(BUSINESSNAME_DESCRIPTOR)
        field(BUSINESSPHONENUMBER_DESCRIPTOR)
        field(EMAILADDRESS_DESCRIPTOR)
        field(FIRSTNAME_DESCRIPTOR)
        field(GENDER_DESCRIPTOR)
        field(GENDERSTRING_DESCRIPTOR)
        field(HOMEPHONENUMBER_DESCRIPTOR)
        field(LASTNAME_DESCRIPTOR)
        field(MAILINGADDRESS_DESCRIPTOR)
        field(MIDDLENAME_DESCRIPTOR)
        field(MOBILEPHONENUMBER_DESCRIPTOR)
        field(PARTYTYPE_DESCRIPTOR)
        field(PARTYTYPESTRING_DESCRIPTOR)
        field(PERSONALEMAILADDRESS_DESCRIPTOR)
        field(PHONENUMBER_DESCRIPTOR)
        field(SHIPPINGADDRESS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accountNumber?.let { field(ACCOUNTNUMBER_DESCRIPTOR, it) }
        input.additionalInformation?.let { field(ADDITIONALINFORMATION_DESCRIPTOR, it) }
        input.address?.let { field(ADDRESS_DESCRIPTOR, it, ::serializeAddressDocument) }
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.billingAddress?.let { field(BILLINGADDRESS_DESCRIPTOR, it, ::serializeAddressDocument) }
        input.birthDate?.let { field(BIRTHDATE_DESCRIPTOR, it) }
        input.businessEmailAddress?.let { field(BUSINESSEMAILADDRESS_DESCRIPTOR, it) }
        input.businessName?.let { field(BUSINESSNAME_DESCRIPTOR, it) }
        input.businessPhoneNumber?.let { field(BUSINESSPHONENUMBER_DESCRIPTOR, it) }
        input.emailAddress?.let { field(EMAILADDRESS_DESCRIPTOR, it) }
        input.firstName?.let { field(FIRSTNAME_DESCRIPTOR, it) }
        input.gender?.let { field(GENDER_DESCRIPTOR, it.value) }
        input.genderString?.let { field(GENDERSTRING_DESCRIPTOR, it) }
        input.homePhoneNumber?.let { field(HOMEPHONENUMBER_DESCRIPTOR, it) }
        input.lastName?.let { field(LASTNAME_DESCRIPTOR, it) }
        input.mailingAddress?.let { field(MAILINGADDRESS_DESCRIPTOR, it, ::serializeAddressDocument) }
        input.middleName?.let { field(MIDDLENAME_DESCRIPTOR, it) }
        input.mobilePhoneNumber?.let { field(MOBILEPHONENUMBER_DESCRIPTOR, it) }
        input.partyType?.let { field(PARTYTYPE_DESCRIPTOR, it.value) }
        input.partyTypeString?.let { field(PARTYTYPESTRING_DESCRIPTOR, it) }
        input.personalEmailAddress?.let { field(PERSONALEMAILADDRESS_DESCRIPTOR, it) }
        input.phoneNumber?.let { field(PHONENUMBER_DESCRIPTOR, it) }
        input.shippingAddress?.let { field(SHIPPINGADDRESS_DESCRIPTOR, it, ::serializeAddressDocument) }
    }
    return serializer.toByteArray()
}
