// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.CreateIntegrationWorkflowRequest
import aws.sdk.kotlin.services.customerprofiles.model.IntegrationConfig
import aws.sdk.kotlin.services.customerprofiles.model.WorkflowType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateIntegrationWorkflowOperationSerializer: HttpSerialize<CreateIntegrationWorkflowRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateIntegrationWorkflowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode("${input.domainName}"))
                add(PercentEncoding.Path.encode("workflows"))
                add(PercentEncoding.Path.encode("integrations"))
            }
        }

        val payload = serializeCreateIntegrationWorkflowOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateIntegrationWorkflowOperationBody(context: ExecutionContext, input: CreateIntegrationWorkflowRequest): ByteArray {
    val serializer = JsonSerializer()
    val INTEGRATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IntegrationConfig"))
    val OBJECTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectTypeName"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val WORKFLOWTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("WorkflowType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INTEGRATIONCONFIG_DESCRIPTOR)
        field(OBJECTTYPENAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(WORKFLOWTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.integrationConfig?.let { field(INTEGRATIONCONFIG_DESCRIPTOR, it, ::serializeIntegrationConfigDocument) }
        input.objectTypeName?.let { field(OBJECTTYPENAME_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.workflowType?.let { field(WORKFLOWTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
