// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



/**
 * The request to enable the rule-based matching.
 */
public class RuleBasedMatchingRequest private constructor(builder: Builder) {
    /**
     * Configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles.
     */
    public val attributeTypesSelector: aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector? = builder.attributeTypesSelector
    /**
     * How the auto-merging process should resolve conflicts between different profiles.
     */
    public val conflictResolution: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution? = builder.conflictResolution
    /**
     * The flag that enables the rule-based matching process of duplicate profiles.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * Configuration information about the S3 bucket where Identity Resolution Jobs writes result files.
     *
     * You need to give Customer Profiles service principal write permission to your S3 bucket. Otherwise, you'll get an exception in the API response. For an example policy, see [Amazon Connect Customer Profiles cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service).
     */
    public val exportingConfig: aws.sdk.kotlin.services.customerprofiles.model.ExportingConfig? = builder.exportingConfig
    /**
     * Configures how the rule-based matching process should match profiles. You can have up to 15 `MatchingRule` in the `MatchingRules`.
     */
    public val matchingRules: List<MatchingRule>? = builder.matchingRules
    /**
     * Indicates the maximum allowed rule level.
     */
    public val maxAllowedRuleLevelForMatching: kotlin.Int? = builder.maxAllowedRuleLevelForMatching
    /**
     * [MatchingRule](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html)
     */
    public val maxAllowedRuleLevelForMerging: kotlin.Int? = builder.maxAllowedRuleLevelForMerging

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleBasedMatchingRequest(")
        append("attributeTypesSelector=$attributeTypesSelector,")
        append("conflictResolution=$conflictResolution,")
        append("enabled=$enabled,")
        append("exportingConfig=$exportingConfig,")
        append("matchingRules=$matchingRules,")
        append("maxAllowedRuleLevelForMatching=$maxAllowedRuleLevelForMatching,")
        append("maxAllowedRuleLevelForMerging=$maxAllowedRuleLevelForMerging")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeTypesSelector?.hashCode() ?: 0
        result = 31 * result + (conflictResolution?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (exportingConfig?.hashCode() ?: 0)
        result = 31 * result + (matchingRules?.hashCode() ?: 0)
        result = 31 * result + (maxAllowedRuleLevelForMatching ?: 0)
        result = 31 * result + (maxAllowedRuleLevelForMerging ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleBasedMatchingRequest

        if (attributeTypesSelector != other.attributeTypesSelector) return false
        if (conflictResolution != other.conflictResolution) return false
        if (enabled != other.enabled) return false
        if (exportingConfig != other.exportingConfig) return false
        if (matchingRules != other.matchingRules) return false
        if (maxAllowedRuleLevelForMatching != other.maxAllowedRuleLevelForMatching) return false
        if (maxAllowedRuleLevelForMerging != other.maxAllowedRuleLevelForMerging) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles.
         */
        public var attributeTypesSelector: aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector? = null
        /**
         * How the auto-merging process should resolve conflicts between different profiles.
         */
        public var conflictResolution: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution? = null
        /**
         * The flag that enables the rule-based matching process of duplicate profiles.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Configuration information about the S3 bucket where Identity Resolution Jobs writes result files.
         *
         * You need to give Customer Profiles service principal write permission to your S3 bucket. Otherwise, you'll get an exception in the API response. For an example policy, see [Amazon Connect Customer Profiles cross-service confused deputy prevention](https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service).
         */
        public var exportingConfig: aws.sdk.kotlin.services.customerprofiles.model.ExportingConfig? = null
        /**
         * Configures how the rule-based matching process should match profiles. You can have up to 15 `MatchingRule` in the `MatchingRules`.
         */
        public var matchingRules: List<MatchingRule>? = null
        /**
         * Indicates the maximum allowed rule level.
         */
        public var maxAllowedRuleLevelForMatching: kotlin.Int? = null
        /**
         * [MatchingRule](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html)
         */
        public var maxAllowedRuleLevelForMerging: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest) : this() {
            this.attributeTypesSelector = x.attributeTypesSelector
            this.conflictResolution = x.conflictResolution
            this.enabled = x.enabled
            this.exportingConfig = x.exportingConfig
            this.matchingRules = x.matchingRules
            this.maxAllowedRuleLevelForMatching = x.maxAllowedRuleLevelForMatching
            this.maxAllowedRuleLevelForMerging = x.maxAllowedRuleLevelForMerging
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingRequest = RuleBasedMatchingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector] inside the given [block]
         */
        public fun attributeTypesSelector(block: aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector.Builder.() -> kotlin.Unit) {
            this.attributeTypesSelector = aws.sdk.kotlin.services.customerprofiles.model.AttributeTypesSelector.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution] inside the given [block]
         */
        public fun conflictResolution(block: aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution.Builder.() -> kotlin.Unit) {
            this.conflictResolution = aws.sdk.kotlin.services.customerprofiles.model.ConflictResolution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.ExportingConfig] inside the given [block]
         */
        public fun exportingConfig(block: aws.sdk.kotlin.services.customerprofiles.model.ExportingConfig.Builder.() -> kotlin.Unit) {
            this.exportingConfig = aws.sdk.kotlin.services.customerprofiles.model.ExportingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
