// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



/**
 * The configurations that control how Customer Profiles retrieves data from the source, Amazon AppFlow. Customer Profiles uses this information to create an AppFlow flow on behalf of customers.
 */
public class FlowDefinition private constructor(builder: Builder) {
    /**
     * A description of the flow you want to create.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
     */
    public val flowName: kotlin.String = requireNotNull(builder.flowName) { "A non-null value must be provided for flowName" }
    /**
     * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
     */
    public val kmsArn: kotlin.String = requireNotNull(builder.kmsArn) { "A non-null value must be provided for kmsArn" }
    /**
     * The configuration that controls how Customer Profiles retrieves data from the source.
     */
    public val sourceFlowConfig: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig? = builder.sourceFlowConfig
    /**
     * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
     */
    public val tasks: List<Task> = requireNotNull(builder.tasks) { "A non-null value must be provided for tasks" }
    /**
     * The trigger settings that determine how and when the flow runs.
     */
    public val triggerConfig: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig? = builder.triggerConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowDefinition(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (flowName.hashCode())
        result = 31 * result + (kmsArn.hashCode())
        result = 31 * result + (sourceFlowConfig?.hashCode() ?: 0)
        result = 31 * result + (tasks.hashCode())
        result = 31 * result + (triggerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowDefinition

        if (description != other.description) return false
        if (flowName != other.flowName) return false
        if (kmsArn != other.kmsArn) return false
        if (sourceFlowConfig != other.sourceFlowConfig) return false
        if (tasks != other.tasks) return false
        if (triggerConfig != other.triggerConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the flow you want to create.
         */
        public var description: kotlin.String? = null
        /**
         * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
         */
        public var flowName: kotlin.String? = null
        /**
         * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
         */
        public var kmsArn: kotlin.String? = null
        /**
         * The configuration that controls how Customer Profiles retrieves data from the source.
         */
        public var sourceFlowConfig: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig? = null
        /**
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         */
        public var tasks: List<Task>? = null
        /**
         * The trigger settings that determine how and when the flow runs.
         */
        public var triggerConfig: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition) : this() {
            this.description = x.description
            this.flowName = x.flowName
            this.kmsArn = x.kmsArn
            this.sourceFlowConfig = x.sourceFlowConfig
            this.tasks = x.tasks
            this.triggerConfig = x.triggerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.FlowDefinition = FlowDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig] inside the given [block]
         */
        public fun sourceFlowConfig(block: aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig.Builder.() -> kotlin.Unit) {
            this.sourceFlowConfig = aws.sdk.kotlin.services.customerprofiles.model.SourceFlowConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig] inside the given [block]
         */
        public fun triggerConfig(block: aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig.Builder.() -> kotlin.Unit) {
            this.triggerConfig = aws.sdk.kotlin.services.customerprofiles.model.TriggerConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (flowName == null) flowName = ""
            if (kmsArn == null) kmsArn = ""
            if (tasks == null) tasks = emptyList()
            return this
        }
    }
}
