// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateDomainResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the domain was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    public val deadLetterQueueUrl: kotlin.String? = builder.deadLetterQueueUrl
    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    public val defaultEncryptionKey: kotlin.String? = builder.defaultEncryptionKey
    /**
     * The default number of days until the data within the domain expires.
     */
    public val defaultExpirationDays: kotlin.Int = requireNotNull(builder.defaultExpirationDays) { "A non-null value must be provided for defaultExpirationDays" }
    /**
     * The unique name of the domain.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The timestamp of when the domain was most recently edited.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     */
    public val matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse? = builder.matching
    /**
     * The process of matching duplicate profiles using the Rule-Based matching. If `RuleBasedMatching` = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the `RuleBasedMatchingRequest`. You can use the `ListRuleBasedMatches` and `GetSimilarProfiles` API to return and review the results. Also, if you have configured `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download the results from S3.
     */
    public val ruleBasedMatching: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse? = builder.ruleBasedMatching
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainResponse(")
        append("createdAt=$createdAt,")
        append("deadLetterQueueUrl=$deadLetterQueueUrl,")
        append("defaultEncryptionKey=$defaultEncryptionKey,")
        append("defaultExpirationDays=$defaultExpirationDays,")
        append("domainName=$domainName,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("matching=$matching,")
        append("ruleBasedMatching=$ruleBasedMatching,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (deadLetterQueueUrl?.hashCode() ?: 0)
        result = 31 * result + (defaultEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (defaultExpirationDays)
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (matching?.hashCode() ?: 0)
        result = 31 * result + (ruleBasedMatching?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainResponse

        if (createdAt != other.createdAt) return false
        if (deadLetterQueueUrl != other.deadLetterQueueUrl) return false
        if (defaultEncryptionKey != other.defaultEncryptionKey) return false
        if (defaultExpirationDays != other.defaultExpirationDays) return false
        if (domainName != other.domainName) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (matching != other.matching) return false
        if (ruleBasedMatching != other.ruleBasedMatching) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the domain was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
         */
        public var deadLetterQueueUrl: kotlin.String? = null
        /**
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
         */
        public var defaultEncryptionKey: kotlin.String? = null
        /**
         * The default number of days until the data within the domain expires.
         */
        public var defaultExpirationDays: kotlin.Int? = null
        /**
         * The unique name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The timestamp of when the domain was most recently edited.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
         *
         * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
         */
        public var matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse? = null
        /**
         * The process of matching duplicate profiles using the Rule-Based matching. If `RuleBasedMatching` = true, Amazon Connect Customer Profiles will start to match and merge your profiles according to your configuration in the `RuleBasedMatchingRequest`. You can use the `ListRuleBasedMatches` and `GetSimilarProfiles` API to return and review the results. Also, if you have configured `ExportingConfig` in the `RuleBasedMatchingRequest`, you can download the results from S3.
         */
        public var ruleBasedMatching: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse) : this() {
            this.createdAt = x.createdAt
            this.deadLetterQueueUrl = x.deadLetterQueueUrl
            this.defaultEncryptionKey = x.defaultEncryptionKey
            this.defaultExpirationDays = x.defaultExpirationDays
            this.domainName = x.domainName
            this.lastUpdatedAt = x.lastUpdatedAt
            this.matching = x.matching
            this.ruleBasedMatching = x.ruleBasedMatching
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.CreateDomainResponse = CreateDomainResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse] inside the given [block]
         */
        public fun matching(block: aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse.Builder.() -> kotlin.Unit) {
            this.matching = aws.sdk.kotlin.services.customerprofiles.model.MatchingResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse] inside the given [block]
         */
        public fun ruleBasedMatching(block: aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse.Builder.() -> kotlin.Unit) {
            this.ruleBasedMatching = aws.sdk.kotlin.services.customerprofiles.model.RuleBasedMatchingResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (defaultExpirationDays == null) defaultExpirationDays = 0
            if (domainName == null) domainName = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
