// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest
import aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDomainOperationSerializer: HttpSerialize<UpdateDomainRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDomainRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "domains",
                "${input.domainName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateDomainOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDomainOperationBody(context: ExecutionContext, input: UpdateDomainRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEADLETTERQUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeadLetterQueueUrl"))
    val DEFAULTENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultEncryptionKey"))
    val DEFAULTEXPIRATIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DefaultExpirationDays"))
    val MATCHING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Matching"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEADLETTERQUEUEURL_DESCRIPTOR)
        field(DEFAULTENCRYPTIONKEY_DESCRIPTOR)
        field(DEFAULTEXPIRATIONDAYS_DESCRIPTOR)
        field(MATCHING_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deadLetterQueueUrl?.let { field(DEADLETTERQUEUEURL_DESCRIPTOR, it) }
        input.defaultEncryptionKey?.let { field(DEFAULTENCRYPTIONKEY_DESCRIPTOR, it) }
        input.defaultExpirationDays?.let { field(DEFAULTEXPIRATIONDAYS_DESCRIPTOR, it) }
        input.matching?.let { field(MATCHING_DESCRIPTOR, it, ::serializeMatchingRequestDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
