// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.services.customerprofiles.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.customerprofiles.model.Status
import aws.sdk.kotlin.services.customerprofiles.model.WorkflowType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListWorkflowsOperationSerializer: HttpSerialize<ListWorkflowsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListWorkflowsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "domains",
                "${input.domainName}".encodeLabel(),
                "workflows",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("max-results", "${input.maxResults}")
                if (input.nextToken != null) append("next-token", input.nextToken)
            }
        }

        val payload = serializeListWorkflowsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListWorkflowsOperationBody(context: ExecutionContext, input: ListWorkflowsRequest): ByteArray {
    val serializer = JsonSerializer()
    val QUERYENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("QueryEndDate"))
    val QUERYSTARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("QueryStartDate"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val WORKFLOWTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkflowType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(QUERYENDDATE_DESCRIPTOR)
        field(QUERYSTARTDATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(WORKFLOWTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.queryEndDate?.let { field(QUERYENDDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.queryStartDate?.let { field(QUERYSTARTDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        input.workflowType?.let { field(WORKFLOWTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
