// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.services.customerprofiles.model.ListProfileObjectsRequest
import aws.sdk.kotlin.services.customerprofiles.model.ObjectFilter
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListProfileObjectsOperationSerializer: HttpSerialize<ListProfileObjectsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListProfileObjectsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "domains",
                "${input.domainName}".encodeLabel(),
                "profiles",
                "objects",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("max-results", "${input.maxResults}")
                if (input.nextToken != null) append("next-token", input.nextToken)
            }
        }

        val payload = serializeListProfileObjectsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListProfileObjectsOperationBody(context: ExecutionContext, input: ListProfileObjectsRequest): ByteArray {
    val serializer = JsonSerializer()
    val OBJECTFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ObjectFilter"))
    val OBJECTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectTypeName"))
    val PROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfileId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OBJECTFILTER_DESCRIPTOR)
        field(OBJECTTYPENAME_DESCRIPTOR)
        field(PROFILEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.objectFilter?.let { field(OBJECTFILTER_DESCRIPTOR, it, ::serializeObjectFilterDocument) }
        input.objectTypeName?.let { field(OBJECTTYPENAME_DESCRIPTOR, it) }
        input.profileId?.let { field(PROFILEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
