// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeTemplateResponse
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeField
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetProfileObjectTypeTemplateOperationDeserializer: HttpDeserialize<GetProfileObjectTypeTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetProfileObjectTypeTemplateResponse {
        if (!response.status.isSuccess()) {
            throwGetProfileObjectTypeTemplateError(context, response)
        }
        val builder = GetProfileObjectTypeTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetProfileObjectTypeTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetProfileObjectTypeTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetProfileObjectTypeTemplateOperationBody(builder: GetProfileObjectTypeTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWPROFILECREATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowProfileCreation"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Fields"))
    val KEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Keys"))
    val KEYS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLastUpdatedTimestampFormat"))
    val SOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceName"))
    val SOURCEOBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceObject"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWPROFILECREATION_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(KEYS_DESCRIPTOR)
        field(SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR)
        field(SOURCENAME_DESCRIPTOR)
        field(SOURCEOBJECT_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWPROFILECREATION_DESCRIPTOR.index -> builder.allowProfileCreation = deserializeBoolean()
                FIELDS_DESCRIPTOR.index -> builder.fields =
                    deserializer.deserializeMap(FIELDS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ObjectTypeField>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeObjectTypeFieldDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                KEYS_DESCRIPTOR.index -> builder.keys =
                    deserializer.deserializeMap(KEYS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<ObjectTypeKey>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(KEYS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<ObjectTypeKey>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeObjectTypeKeyDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR.index -> builder.sourceLastUpdatedTimestampFormat = deserializeString()
                SOURCENAME_DESCRIPTOR.index -> builder.sourceName = deserializeString()
                SOURCEOBJECT_DESCRIPTOR.index -> builder.sourceObject = deserializeString()
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
