// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetProfileObjectTypeResponse
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeField
import aws.sdk.kotlin.services.customerprofiles.model.ObjectTypeKey
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetProfileObjectTypeOperationDeserializer: HttpDeserialize<GetProfileObjectTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetProfileObjectTypeResponse {
        if (!response.status.isSuccess()) {
            throwGetProfileObjectTypeError(context, response)
        }
        val builder = GetProfileObjectTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetProfileObjectTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetProfileObjectTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetProfileObjectTypeOperationBody(builder: GetProfileObjectTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWPROFILECREATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowProfileCreation"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENCRYPTIONKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKey"))
    val EXPIRATIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ExpirationDays"))
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Fields"))
    val KEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Keys"))
    val KEYS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedAt"))
    val OBJECTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectTypeName"))
    val SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLastUpdatedTimestampFormat"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWPROFILECREATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENCRYPTIONKEY_DESCRIPTOR)
        field(EXPIRATIONDAYS_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(KEYS_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(OBJECTTYPENAME_DESCRIPTOR)
        field(SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWPROFILECREATION_DESCRIPTOR.index -> builder.allowProfileCreation = deserializeBoolean()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENCRYPTIONKEY_DESCRIPTOR.index -> builder.encryptionKey = deserializeString()
                EXPIRATIONDAYS_DESCRIPTOR.index -> builder.expirationDays = deserializeInt()
                FIELDS_DESCRIPTOR.index -> builder.fields =
                    deserializer.deserializeMap(FIELDS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ObjectTypeField>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeObjectTypeFieldDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                KEYS_DESCRIPTOR.index -> builder.keys =
                    deserializer.deserializeMap(KEYS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<ObjectTypeKey>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(KEYS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<ObjectTypeKey>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeObjectTypeKeyDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                OBJECTTYPENAME_DESCRIPTOR.index -> builder.objectTypeName = deserializeString()
                SOURCELASTUPDATEDTIMESTAMPFORMAT_DESCRIPTOR.index -> builder.sourceLastUpdatedTimestampFormat = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
