// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetMatchesResponse
import aws.sdk.kotlin.services.customerprofiles.model.MatchItem
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetMatchesOperationDeserializer: HttpDeserialize<GetMatchesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMatchesResponse {
        if (!response.status.isSuccess()) {
            throwGetMatchesError(context, response)
        }
        val builder = GetMatchesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMatchesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMatchesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMatchesOperationBody(builder: GetMatchesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MATCHGENERATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("MatchGenerationDate"))
    val MATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Matches"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val POTENTIALMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PotentialMatches"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MATCHGENERATIONDATE_DESCRIPTOR)
        field(MATCHES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(POTENTIALMATCHES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MATCHGENERATIONDATE_DESCRIPTOR.index -> builder.matchGenerationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                MATCHES_DESCRIPTOR.index -> builder.matches =
                    deserializer.deserializeList(MATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<MatchItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMatchItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                POTENTIALMATCHES_DESCRIPTOR.index -> builder.potentialMatches = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
