// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.customerprofiles.model.CustomerProfilesException
import aws.sdk.kotlin.services.customerprofiles.model.GetAutoMergingPreviewResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAutoMergingPreviewOperationDeserializer: HttpDeserialize<GetAutoMergingPreviewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAutoMergingPreviewResponse {
        if (!response.status.isSuccess()) {
            throwGetAutoMergingPreviewError(context, response)
        }
        val builder = GetAutoMergingPreviewResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAutoMergingPreviewOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAutoMergingPreviewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CustomerProfilesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CustomerProfilesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAutoMergingPreviewOperationBody(builder: GetAutoMergingPreviewResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val NUMBEROFMATCHESINSAMPLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfMatchesInSample"))
    val NUMBEROFPROFILESINSAMPLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfProfilesInSample"))
    val NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfProfilesWillBeMerged"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINNAME_DESCRIPTOR)
        field(NUMBEROFMATCHESINSAMPLE_DESCRIPTOR)
        field(NUMBEROFPROFILESINSAMPLE_DESCRIPTOR)
        field(NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                NUMBEROFMATCHESINSAMPLE_DESCRIPTOR.index -> builder.numberOfMatchesInSample = deserializeLong()
                NUMBEROFPROFILESINSAMPLE_DESCRIPTOR.index -> builder.numberOfProfilesInSample = deserializeLong()
                NUMBEROFPROFILESWILLBEMERGED_DESCRIPTOR.index -> builder.numberOfProfilesWillBeMerged = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
