// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.transform

import aws.sdk.kotlin.services.customerprofiles.model.DeleteProfileObjectRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteProfileObjectOperationSerializer: HttpSerialize<DeleteProfileObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DeleteProfileObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "domains",
                "${input.domainName}".encodeLabel(),
                "profiles",
                "objects",
                "delete",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeDeleteProfileObjectOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeDeleteProfileObjectOperationBody(context: ExecutionContext, input: DeleteProfileObjectRequest): ByteArray {
    val serializer = JsonSerializer()
    val OBJECTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ObjectTypeName"))
    val PROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfileId"))
    val PROFILEOBJECTUNIQUEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfileObjectUniqueKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OBJECTTYPENAME_DESCRIPTOR)
        field(PROFILEID_DESCRIPTOR)
        field(PROFILEOBJECTUNIQUEKEY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.objectTypeName?.let { field(OBJECTTYPENAME_DESCRIPTOR, it) }
        input.profileId?.let { field(PROFILEID_DESCRIPTOR, it) }
        input.profileObjectUniqueKey?.let { field(PROFILEOBJECTUNIQUEKEY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
