// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



class UpdateDomainRequest private constructor(builder: Builder) {
    /**
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
     */
    val deadLetterQueueUrl: kotlin.String? = builder.deadLetterQueueUrl
    /**
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.
     */
    val defaultEncryptionKey: kotlin.String? = builder.defaultEncryptionKey
    /**
     * The default number of days until the data within the domain expires.
     */
    val defaultExpirationDays: kotlin.Int? = builder.defaultExpirationDays
    /**
     * The unique name of the domain.
     */
    val domainName: kotlin.String? = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
     *
     * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
     */
    val matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest? = builder.matching
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainRequest(")
        append("deadLetterQueueUrl=$deadLetterQueueUrl,")
        append("defaultEncryptionKey=$defaultEncryptionKey,")
        append("defaultExpirationDays=$defaultExpirationDays,")
        append("domainName=$domainName,")
        append("matching=$matching,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deadLetterQueueUrl?.hashCode() ?: 0
        result = 31 * result + (defaultEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (defaultExpirationDays ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (matching?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainRequest

        if (deadLetterQueueUrl != other.deadLetterQueueUrl) return false
        if (defaultEncryptionKey != other.defaultEncryptionKey) return false
        if (defaultExpirationDays != other.defaultExpirationDays) return false
        if (domainName != other.domainName) return false
        if (matching != other.matching) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
         */
        var deadLetterQueueUrl: kotlin.String? = null
        /**
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.
         */
        var defaultEncryptionKey: kotlin.String? = null
        /**
         * The default number of days until the data within the domain expires.
         */
        var defaultExpirationDays: kotlin.Int? = null
        /**
         * The unique name of the domain.
         */
        var domainName: kotlin.String? = null
        /**
         * The process of matching duplicate profiles. If `Matching` = `true`, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains.
         *
         * After the Identity Resolution Job completes, use the [GetMatches](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html) API to return and review the results. Or, if you have configured `ExportingConfig` in the `MatchingRequest`, you can download the results from S3.
         */
        var matching: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest) : this() {
            this.deadLetterQueueUrl = x.deadLetterQueueUrl
            this.defaultEncryptionKey = x.defaultEncryptionKey
            this.defaultExpirationDays = x.defaultExpirationDays
            this.domainName = x.domainName
            this.matching = x.matching
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.UpdateDomainRequest = UpdateDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest] inside the given [block]
         */
        fun matching(block: aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest.Builder.() -> kotlin.Unit) {
            this.matching = aws.sdk.kotlin.services.customerprofiles.model.MatchingRequest.invoke(block)
        }
    }
}
