// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model

import aws.smithy.kotlin.runtime.time.Instant

class PutProfileObjectTypeResponse private constructor(builder: Builder) {
    /**
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
     */
    val allowProfileCreation: kotlin.Boolean = builder.allowProfileCreation
    /**
     * The timestamp of when the domain was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Description of the profile object type.
     */
    val description: kotlin.String? = builder.description
    /**
     * The customer-provided key to encrypt the profile object that will be created in this profile object type.
     */
    val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The number of days until the data in the object expires.
     */
    val expirationDays: kotlin.Int? = builder.expirationDays
    /**
     * A map of the name and ObjectType field.
     */
    val fields: Map<String, ObjectTypeField>? = builder.fields
    /**
     * A list of unique keys that can be used to map data to the profile.
     */
    val keys: Map<String, List<ObjectTypeKey>>? = builder.keys
    /**
     * The timestamp of when the domain was most recently edited.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the profile object type.
     */
    val objectTypeName: kotlin.String? = builder.objectTypeName
    /**
     * The format of your `sourceLastUpdatedTimestamp` that was previously set up in fields that were parsed using [SimpleDateFormat](https://docs.oracle.com/javase/10/docs/api/java/text/SimpleDateFormat.html). If you have `sourceLastUpdatedTimestamp` in your field, you must set up `sourceLastUpdatedTimestampFormat`.
     */
    val sourceLastUpdatedTimestampFormat: kotlin.String? = builder.sourceLastUpdatedTimestampFormat
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A unique identifier for the object template.
     */
    val templateId: kotlin.String? = builder.templateId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutProfileObjectTypeResponse(")
        append("allowProfileCreation=$allowProfileCreation,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("encryptionKey=$encryptionKey,")
        append("expirationDays=$expirationDays,")
        append("fields=$fields,")
        append("keys=$keys,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("objectTypeName=$objectTypeName,")
        append("sourceLastUpdatedTimestampFormat=$sourceLastUpdatedTimestampFormat,")
        append("tags=$tags,")
        append("templateId=$templateId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowProfileCreation.hashCode()
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (expirationDays ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (objectTypeName?.hashCode() ?: 0)
        result = 31 * result + (sourceLastUpdatedTimestampFormat?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutProfileObjectTypeResponse

        if (allowProfileCreation != other.allowProfileCreation) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (encryptionKey != other.encryptionKey) return false
        if (expirationDays != other.expirationDays) return false
        if (fields != other.fields) return false
        if (keys != other.keys) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (objectTypeName != other.objectTypeName) return false
        if (sourceLastUpdatedTimestampFormat != other.sourceLastUpdatedTimestampFormat) return false
        if (tags != other.tags) return false
        if (templateId != other.templateId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
         */
        var allowProfileCreation: kotlin.Boolean = false
        /**
         * The timestamp of when the domain was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Description of the profile object type.
         */
        var description: kotlin.String? = null
        /**
         * The customer-provided key to encrypt the profile object that will be created in this profile object type.
         */
        var encryptionKey: kotlin.String? = null
        /**
         * The number of days until the data in the object expires.
         */
        var expirationDays: kotlin.Int? = null
        /**
         * A map of the name and ObjectType field.
         */
        var fields: Map<String, ObjectTypeField>? = null
        /**
         * A list of unique keys that can be used to map data to the profile.
         */
        var keys: Map<String, List<ObjectTypeKey>>? = null
        /**
         * The timestamp of when the domain was most recently edited.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the profile object type.
         */
        var objectTypeName: kotlin.String? = null
        /**
         * The format of your `sourceLastUpdatedTimestamp` that was previously set up in fields that were parsed using [SimpleDateFormat](https://docs.oracle.com/javase/10/docs/api/java/text/SimpleDateFormat.html). If you have `sourceLastUpdatedTimestamp` in your field, you must set up `sourceLastUpdatedTimestampFormat`.
         */
        var sourceLastUpdatedTimestampFormat: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null
        /**
         * A unique identifier for the object template.
         */
        var templateId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeResponse) : this() {
            this.allowProfileCreation = x.allowProfileCreation
            this.createdAt = x.createdAt
            this.description = x.description
            this.encryptionKey = x.encryptionKey
            this.expirationDays = x.expirationDays
            this.fields = x.fields
            this.keys = x.keys
            this.lastUpdatedAt = x.lastUpdatedAt
            this.objectTypeName = x.objectTypeName
            this.sourceLastUpdatedTimestampFormat = x.sourceLastUpdatedTimestampFormat
            this.tags = x.tags
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeResponse = PutProfileObjectTypeResponse(this)
    }
}
