// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



class PutProfileObjectTypeRequest private constructor(builder: Builder) {
    /**
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
     */
    val allowProfileCreation: kotlin.Boolean = builder.allowProfileCreation
    /**
     * Description of the profile object type.
     */
    val description: kotlin.String? = builder.description
    /**
     * The unique name of the domain.
     */
    val domainName: kotlin.String? = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The customer-provided key to encrypt the profile object that will be created in this profile object type.
     */
    val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The number of days until the data in the object expires.
     */
    val expirationDays: kotlin.Int? = builder.expirationDays
    /**
     * A map of the name and ObjectType field.
     */
    val fields: Map<String, ObjectTypeField>? = builder.fields
    /**
     * A list of unique keys that can be used to map data to the profile.
     */
    val keys: Map<String, List<ObjectTypeKey>>? = builder.keys
    /**
     * The name of the profile object type.
     */
    val objectTypeName: kotlin.String? = requireNotNull(builder.objectTypeName) { "A non-null value must be provided for objectTypeName" }
    /**
     * The format of your `sourceLastUpdatedTimestamp` that was previously set up.
     */
    val sourceLastUpdatedTimestampFormat: kotlin.String? = builder.sourceLastUpdatedTimestampFormat
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A unique identifier for the object template.
     */
    val templateId: kotlin.String? = builder.templateId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutProfileObjectTypeRequest(")
        append("allowProfileCreation=$allowProfileCreation,")
        append("description=$description,")
        append("domainName=$domainName,")
        append("encryptionKey=$encryptionKey,")
        append("expirationDays=$expirationDays,")
        append("fields=$fields,")
        append("keys=$keys,")
        append("objectTypeName=$objectTypeName,")
        append("sourceLastUpdatedTimestampFormat=$sourceLastUpdatedTimestampFormat,")
        append("tags=$tags,")
        append("templateId=$templateId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowProfileCreation.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (expirationDays ?: 0)
        result = 31 * result + (fields?.hashCode() ?: 0)
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (objectTypeName?.hashCode() ?: 0)
        result = 31 * result + (sourceLastUpdatedTimestampFormat?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutProfileObjectTypeRequest

        if (allowProfileCreation != other.allowProfileCreation) return false
        if (description != other.description) return false
        if (domainName != other.domainName) return false
        if (encryptionKey != other.encryptionKey) return false
        if (expirationDays != other.expirationDays) return false
        if (fields != other.fields) return false
        if (keys != other.keys) return false
        if (objectTypeName != other.objectTypeName) return false
        if (sourceLastUpdatedTimestampFormat != other.sourceLastUpdatedTimestampFormat) return false
        if (tags != other.tags) return false
        if (templateId != other.templateId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is `FALSE`. If the AllowProfileCreation flag is set to `FALSE`, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to `TRUE`, and if no match is found, then the service creates a new standard profile.
         */
        var allowProfileCreation: kotlin.Boolean = false
        /**
         * Description of the profile object type.
         */
        var description: kotlin.String? = null
        /**
         * The unique name of the domain.
         */
        var domainName: kotlin.String? = null
        /**
         * The customer-provided key to encrypt the profile object that will be created in this profile object type.
         */
        var encryptionKey: kotlin.String? = null
        /**
         * The number of days until the data in the object expires.
         */
        var expirationDays: kotlin.Int? = null
        /**
         * A map of the name and ObjectType field.
         */
        var fields: Map<String, ObjectTypeField>? = null
        /**
         * A list of unique keys that can be used to map data to the profile.
         */
        var keys: Map<String, List<ObjectTypeKey>>? = null
        /**
         * The name of the profile object type.
         */
        var objectTypeName: kotlin.String? = null
        /**
         * The format of your `sourceLastUpdatedTimestamp` that was previously set up.
         */
        var sourceLastUpdatedTimestampFormat: kotlin.String? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null
        /**
         * A unique identifier for the object template.
         */
        var templateId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest) : this() {
            this.allowProfileCreation = x.allowProfileCreation
            this.description = x.description
            this.domainName = x.domainName
            this.encryptionKey = x.encryptionKey
            this.expirationDays = x.expirationDays
            this.fields = x.fields
            this.keys = x.keys
            this.objectTypeName = x.objectTypeName
            this.sourceLastUpdatedTimestampFormat = x.sourceLastUpdatedTimestampFormat
            this.tags = x.tags
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.PutProfileObjectTypeRequest = PutProfileObjectTypeRequest(this)
    }
}
