// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.model



/**
 * The standard profile of a customer.
 */
class Profile private constructor(builder: Builder) {
    /**
     * A unique account number that you have given to the customer.
     */
    val accountNumber: kotlin.String? = builder.accountNumber
    /**
     * Any additional information relevant to the customer’s profile.
     */
    val additionalInformation: kotlin.String? = builder.additionalInformation
    /**
     * A generic address associated with the customer that is not mailing, shipping, or billing.
     */
    val address: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.address
    /**
     * A key value pair of attributes of a customer profile.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The customer’s billing address.
     */
    val billingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.billingAddress
    /**
     * The customer’s birth date.
     */
    val birthDate: kotlin.String? = builder.birthDate
    /**
     * The customer’s business email address.
     */
    val businessEmailAddress: kotlin.String? = builder.businessEmailAddress
    /**
     * The name of the customer’s business.
     */
    val businessName: kotlin.String? = builder.businessName
    /**
     * The customer’s home phone number.
     */
    val businessPhoneNumber: kotlin.String? = builder.businessPhoneNumber
    /**
     * The customer’s email address, which has not been specified as a personal or business address.
     */
    val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * The customer’s first name.
     */
    val firstName: kotlin.String? = builder.firstName
    /**
     * The gender with which the customer identifies.
     */
    val gender: aws.sdk.kotlin.services.customerprofiles.model.Gender? = builder.gender
    /**
     * The customer’s home phone number.
     */
    val homePhoneNumber: kotlin.String? = builder.homePhoneNumber
    /**
     * The customer’s last name.
     */
    val lastName: kotlin.String? = builder.lastName
    /**
     * The customer’s mailing address.
     */
    val mailingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.mailingAddress
    /**
     * The customer’s middle name.
     */
    val middleName: kotlin.String? = builder.middleName
    /**
     * The customer’s mobile phone number.
     */
    val mobilePhoneNumber: kotlin.String? = builder.mobilePhoneNumber
    /**
     * The type of profile used to describe the customer.
     */
    val partyType: aws.sdk.kotlin.services.customerprofiles.model.PartyType? = builder.partyType
    /**
     * The customer’s personal email address.
     */
    val personalEmailAddress: kotlin.String? = builder.personalEmailAddress
    /**
     * The customer's phone number, which has not been specified as a mobile, home, or business number.
     */
    val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The unique identifier of a customer profile.
     */
    val profileId: kotlin.String? = builder.profileId
    /**
     * The customer’s shipping address.
     */
    val shippingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = builder.shippingAddress

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.customerprofiles.model.Profile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Profile(")
        append("accountNumber=$accountNumber,")
        append("additionalInformation=$additionalInformation,")
        append("address=$address,")
        append("attributes=$attributes,")
        append("billingAddress=$billingAddress,")
        append("birthDate=$birthDate,")
        append("businessEmailAddress=$businessEmailAddress,")
        append("businessName=$businessName,")
        append("businessPhoneNumber=$businessPhoneNumber,")
        append("emailAddress=$emailAddress,")
        append("firstName=$firstName,")
        append("gender=$gender,")
        append("homePhoneNumber=$homePhoneNumber,")
        append("lastName=$lastName,")
        append("mailingAddress=$mailingAddress,")
        append("middleName=$middleName,")
        append("mobilePhoneNumber=$mobilePhoneNumber,")
        append("partyType=$partyType,")
        append("personalEmailAddress=$personalEmailAddress,")
        append("phoneNumber=$phoneNumber,")
        append("profileId=$profileId,")
        append("shippingAddress=$shippingAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountNumber?.hashCode() ?: 0
        result = 31 * result + (additionalInformation?.hashCode() ?: 0)
        result = 31 * result + (address?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (billingAddress?.hashCode() ?: 0)
        result = 31 * result + (birthDate?.hashCode() ?: 0)
        result = 31 * result + (businessEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (businessName?.hashCode() ?: 0)
        result = 31 * result + (businessPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (gender?.hashCode() ?: 0)
        result = 31 * result + (homePhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (mailingAddress?.hashCode() ?: 0)
        result = 31 * result + (middleName?.hashCode() ?: 0)
        result = 31 * result + (mobilePhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (partyType?.hashCode() ?: 0)
        result = 31 * result + (personalEmailAddress?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (profileId?.hashCode() ?: 0)
        result = 31 * result + (shippingAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Profile

        if (accountNumber != other.accountNumber) return false
        if (additionalInformation != other.additionalInformation) return false
        if (address != other.address) return false
        if (attributes != other.attributes) return false
        if (billingAddress != other.billingAddress) return false
        if (birthDate != other.birthDate) return false
        if (businessEmailAddress != other.businessEmailAddress) return false
        if (businessName != other.businessName) return false
        if (businessPhoneNumber != other.businessPhoneNumber) return false
        if (emailAddress != other.emailAddress) return false
        if (firstName != other.firstName) return false
        if (gender != other.gender) return false
        if (homePhoneNumber != other.homePhoneNumber) return false
        if (lastName != other.lastName) return false
        if (mailingAddress != other.mailingAddress) return false
        if (middleName != other.middleName) return false
        if (mobilePhoneNumber != other.mobilePhoneNumber) return false
        if (partyType != other.partyType) return false
        if (personalEmailAddress != other.personalEmailAddress) return false
        if (phoneNumber != other.phoneNumber) return false
        if (profileId != other.profileId) return false
        if (shippingAddress != other.shippingAddress) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.customerprofiles.model.Profile = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique account number that you have given to the customer.
         */
        var accountNumber: kotlin.String? = null
        /**
         * Any additional information relevant to the customer’s profile.
         */
        var additionalInformation: kotlin.String? = null
        /**
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         */
        var address: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * A key value pair of attributes of a customer profile.
         */
        var attributes: Map<String, String>? = null
        /**
         * The customer’s billing address.
         */
        var billingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * The customer’s birth date.
         */
        var birthDate: kotlin.String? = null
        /**
         * The customer’s business email address.
         */
        var businessEmailAddress: kotlin.String? = null
        /**
         * The name of the customer’s business.
         */
        var businessName: kotlin.String? = null
        /**
         * The customer’s home phone number.
         */
        var businessPhoneNumber: kotlin.String? = null
        /**
         * The customer’s email address, which has not been specified as a personal or business address.
         */
        var emailAddress: kotlin.String? = null
        /**
         * The customer’s first name.
         */
        var firstName: kotlin.String? = null
        /**
         * The gender with which the customer identifies.
         */
        var gender: aws.sdk.kotlin.services.customerprofiles.model.Gender? = null
        /**
         * The customer’s home phone number.
         */
        var homePhoneNumber: kotlin.String? = null
        /**
         * The customer’s last name.
         */
        var lastName: kotlin.String? = null
        /**
         * The customer’s mailing address.
         */
        var mailingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null
        /**
         * The customer’s middle name.
         */
        var middleName: kotlin.String? = null
        /**
         * The customer’s mobile phone number.
         */
        var mobilePhoneNumber: kotlin.String? = null
        /**
         * The type of profile used to describe the customer.
         */
        var partyType: aws.sdk.kotlin.services.customerprofiles.model.PartyType? = null
        /**
         * The customer’s personal email address.
         */
        var personalEmailAddress: kotlin.String? = null
        /**
         * The customer's phone number, which has not been specified as a mobile, home, or business number.
         */
        var phoneNumber: kotlin.String? = null
        /**
         * The unique identifier of a customer profile.
         */
        var profileId: kotlin.String? = null
        /**
         * The customer’s shipping address.
         */
        var shippingAddress: aws.sdk.kotlin.services.customerprofiles.model.Address? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.customerprofiles.model.Profile) : this() {
            this.accountNumber = x.accountNumber
            this.additionalInformation = x.additionalInformation
            this.address = x.address
            this.attributes = x.attributes
            this.billingAddress = x.billingAddress
            this.birthDate = x.birthDate
            this.businessEmailAddress = x.businessEmailAddress
            this.businessName = x.businessName
            this.businessPhoneNumber = x.businessPhoneNumber
            this.emailAddress = x.emailAddress
            this.firstName = x.firstName
            this.gender = x.gender
            this.homePhoneNumber = x.homePhoneNumber
            this.lastName = x.lastName
            this.mailingAddress = x.mailingAddress
            this.middleName = x.middleName
            this.mobilePhoneNumber = x.mobilePhoneNumber
            this.partyType = x.partyType
            this.personalEmailAddress = x.personalEmailAddress
            this.phoneNumber = x.phoneNumber
            this.profileId = x.profileId
            this.shippingAddress = x.shippingAddress
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.customerprofiles.model.Profile = Profile(this)

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        fun address(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.address = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        fun billingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.billingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        fun mailingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.mailingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.customerprofiles.model.Address] inside the given [block]
         */
        fun shippingAddress(block: aws.sdk.kotlin.services.customerprofiles.model.Address.Builder.() -> kotlin.Unit) {
            this.shippingAddress = aws.sdk.kotlin.services.customerprofiles.model.Address.invoke(block)
        }
    }
}
